/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.actions.ViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectBranchPointDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

public class SwitchTargetAction
extends ViewAction {
    public static final String ID = "switch-target";
    private static final String TITLE = Messages.getString("SwitchTargetAction.0");
    private static final String TOOL_TIP = Messages.getString("SwitchTargetAction.1");
    private CDOBranchPoint target;

    public SwitchTargetAction(IWorkbenchPage page, CDOView view) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, null, view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        CDOView view = this.getView();
        SelectBranchPointDialog dialog = new SelectBranchPointDialog(this.getPage(), view.getSession(), (CDOBranchPoint)view, view.isReadOnly()){

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(TITLE);
                this.setTitle(TITLE);
                this.setTitleImage(SharedIcons.getImage((String)"wizban/BranchBanner.gif"));
                this.setMessage("Compose a valid target point or select one from commits, tags or views.");
                return super.createDialogArea(parent);
            }

            protected String getComposeTabTitle() {
                return "Target Point";
            }
        };
        if (dialog.open() == 0) {
            this.target = dialog.getBranchPoint();
            if (this.target == null) {
                this.cancel();
            }
        } else {
            this.cancel();
        }
        super.preRun();
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOView view = this.getView();
        view.setBranchPoint(this.target);
    }
}

