/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.util.List;
import org.eclipse.emf.cdo.CDONotification;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.object.CDOLegacyWrapper;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOLegacyAdapter
extends CDOLegacyWrapper
implements Adapter.Internal {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyAdapter.class);

    public CDOLegacyAdapter(InternalEObject object) {
        super(object);
        this.instance.eAdapters().add((Object)this);
        ((BasicNotifierImpl.EObservableAdapterList)this.instance.eAdapters()).addListener((BasicNotifierImpl.EObservableAdapterList.Listener)new AdapterListListener());
    }

    public void setTarget(Notifier newTarget) {
        this.instance = (InternalEObject)newTarget;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (this.instance == oldTarget) {
            this.instance = null;
        }
    }

    public Notifier getTarget() {
        return this.instance;
    }

    public boolean isAdapterForType(Object type) {
        return type == CDOLegacyAdapter.class;
    }

    public void notifyChanged(Notification msg) {
        if (msg.isTouch() || msg instanceof CDONotification) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
        if (this.view == null || feature == null || !(this.view instanceof CDOTransaction)) {
            return;
        }
        if (EMFUtil.isPersistent((EStructuralFeature)feature)) {
            int eventType = msg.getEventType();
            int position = msg.getPosition();
            Object oldValue = msg.getOldValue();
            Object newValue = msg.getNewValue();
            switch (eventType) {
                case 1: {
                    this.notifySet(feature, position, oldValue, newValue);
                    break;
                }
                case 2: {
                    this.notifyUnset(feature, oldValue);
                    break;
                }
                case 7: {
                    this.notifyMove(feature, position, oldValue);
                    break;
                }
                case 3: {
                    this.notifyAdd(feature, position, newValue);
                    break;
                }
                case 5: {
                    this.notifyAddMany(feature, position, newValue);
                    break;
                }
                case 4: {
                    this.notifyRemove(feature, position);
                    break;
                }
                case 6: {
                    this.notifyRemoveMany(feature, oldValue);
                }
            }
            this.instanceToRevisionContainment();
        }
    }

    protected void notifySet(EStructuralFeature feature, int position, Object oldValue, Object newValue) {
        EReference reference;
        CDOStore store = this.view.getStore();
        store.set(this.instance, feature, position, newValue);
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            if (oldValue != null) {
                InternalEObject oldChild = (InternalEObject)oldValue;
                this.setContainer(store, oldChild, null, 0);
            }
            if (newValue != null) {
                InternalEObject newChild = (InternalEObject)newValue;
                this.setContainer(store, newChild, this, reference.getFeatureID());
            }
        }
    }

    protected void notifyUnset(EStructuralFeature feature, Object oldValue) {
        EReference reference;
        CDOStore store = this.view.getStore();
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            List list = (List)oldValue;
            for (Object child : list) {
                if (child == null) continue;
                this.setContainer(store, (InternalEObject)child, null, 0);
            }
        }
        store.unset(this.instance, feature);
    }

    protected void notifyMove(EStructuralFeature feature, int position, Object oldValue) {
        CDOStore store = this.view.getStore();
        store.move(this.instance, feature, position, (Integer)oldValue);
    }

    protected void notifyAdd(EStructuralFeature feature, int position, Object newValue) {
        EReference reference;
        CDOStore store = this.view.getStore();
        store.add(this.instance, feature, position, newValue);
        if (newValue != null && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            InternalEObject newChild = (InternalEObject)newValue;
            this.setContainer(store, newChild, this, reference.getFeatureID());
        }
    }

    protected void notifyAddMany(EStructuralFeature feature, int position, Object newValue) {
        CDOStore store = this.view.getStore();
        int pos = position;
        List list = (List)newValue;
        for (Object object : list) {
            EReference reference;
            store.add(this.instance, feature, pos++, object);
            if (object == null || !(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) continue;
            InternalEObject newChild = (InternalEObject)object;
            this.setContainer(store, newChild, this, reference.getFeatureID());
        }
    }

    protected void notifyRemove(EStructuralFeature feature, int position) {
        EReference reference;
        CDOStore store = this.view.getStore();
        Object oldChild = store.remove(this.instance, feature, position);
        if (oldChild instanceof InternalEObject && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            InternalEObject oldChildEObject = (InternalEObject)oldChild;
            this.setContainer(store, oldChildEObject, null, 0);
        }
    }

    protected void notifyRemoveMany(EStructuralFeature feature, Object oldValue) {
        CDOStore store = this.view.getStore();
        List list = (List)oldValue;
        int i = list.size() - 1;
        while (i >= 0) {
            EReference reference;
            Object oldChild = store.remove(this.instance, feature, i);
            if (oldChild instanceof InternalEObject && feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                InternalEObject oldChildEObject = (InternalEObject)oldChild;
                this.setContainer(store, oldChildEObject, null, 0);
            }
            --i;
        }
    }

    private void setContainer(CDOStore store, InternalEObject object, InternalEObject container, int containingFeatureID) {
        if (object instanceof CDOObjectImpl) {
            return;
        }
        if (FSMUtil.isTransient(CDOUtil.getCDOObject((EObject)object))) {
            return;
        }
        store.setContainer(object, null, container, -1 - containingFeatureID);
    }

    protected class AdapterListListener
    implements BasicNotifierImpl.EObservableAdapterList.Listener {
        public void added(Notifier notifier, Adapter adapter) {
            if (TRACER.isEnabled()) {
                TRACER.format("Added : {0} to {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this)) {
                CDOLegacyAdapter.this.cdoView().handleAddAdapter(CDOLegacyAdapter.this, adapter);
            }
        }

        public void removed(Notifier notifier, Adapter adapter) {
            if (TRACER.isEnabled()) {
                TRACER.format("Removed : {0} from {1} ", new Object[]{adapter, CDOLegacyAdapter.this});
            }
            if (!FSMUtil.isTransient(CDOLegacyAdapter.this)) {
                CDOLegacyAdapter.this.cdoView().handleRemoveAdapter(CDOLegacyAdapter.this, adapter);
            }
        }
    }
}

