/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.object.CDODeltaNotificationImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDONotificationBuilder
extends CDOFeatureDeltaVisitorImpl {
    private CDOView view;
    private InternalEObject object;
    private CDORevisionDelta revisionDelta;
    private NotificationChainImpl notification;
    private Set<CDOObject> detachedObjects;
    private InternalCDORevision oldRevision;

    public CDONotificationBuilder(CDOView view) {
        this.view = view;
    }

    public CDOView getView() {
        return this.view;
    }

    public synchronized NotificationChain buildNotification(InternalEObject object, InternalCDORevision oldRevision, CDORevisionDelta revisionDelta, Set<CDOObject> detachedObjects) {
        this.notification = new NotificationChainImpl();
        this.object = object;
        this.revisionDelta = revisionDelta;
        this.detachedObjects = detachedObjects;
        this.oldRevision = oldRevision;
        revisionDelta.accept((CDOFeatureDeltaVisitor)this);
        return this.notification;
    }

    public synchronized NotificationChain buildNotification(InternalCDOObject object, InternalCDORevision newRevision) {
        InternalCDORevision oldRevision = (InternalCDORevision)CDORevisionFactory.DEFAULT.createRevision(object.eClass());
        InternalCDORevisionDelta revisionDelta = newRevision.compare((CDORevision)oldRevision);
        return this.buildNotification(object, oldRevision, (CDORevisionDelta)revisionDelta, null);
    }

    public void visit(CDOMoveFeatureDelta delta) {
        CDOID oldID;
        CDOObject object;
        EStructuralFeature feature = delta.getFeature();
        int oldPosition = delta.getOldPosition();
        int newPosition = delta.getNewPosition();
        Object oldValue = delta.getValue();
        if (oldValue instanceof CDOID && (object = this.findObjectByID(oldID = (CDOID)oldValue)) != null) {
            oldValue = object;
        }
        this.add(new CDODeltaNotificationImpl(this.object, 7, this.getEFeatureID(feature), oldPosition, oldValue, newPosition));
    }

    public void visit(CDOAddFeatureDelta delta) {
        EStructuralFeature feature = delta.getFeature();
        this.add(new CDODeltaNotificationImpl(this.object, 3, this.getEFeatureID(feature), this.getOldValue(feature), delta.getValue(), delta.getIndex()));
    }

    public void visit(CDORemoveFeatureDelta delta) {
        CDOID oldID;
        CDOObject object;
        EStructuralFeature feature = delta.getFeature();
        int index = delta.getIndex();
        Object oldValue = delta.getValue();
        if (oldValue instanceof CDOID && (object = this.findObjectByID(oldID = (CDOID)oldValue)) != null) {
            oldValue = object;
        }
        this.add(new CDODeltaNotificationImpl(this.object, 4, this.getEFeatureID(feature), oldValue, null, index));
    }

    public void visit(CDOSetFeatureDelta delta) {
        CDOID oldID;
        CDOObject object;
        EStructuralFeature feature = delta.getFeature();
        Object oldValue = this.getOldValue(feature);
        if (oldValue instanceof CDOID && (object = this.findObjectByID(oldID = (CDOID)oldValue)) != null) {
            oldValue = object;
        }
        this.add(new CDODeltaNotificationImpl(this.object, 1, this.getEFeatureID(feature), oldValue, delta.getValue(), delta.getIndex()));
    }

    public void visit(CDOUnsetFeatureDelta delta) {
        CDOID oldID;
        CDOObject object;
        EStructuralFeature feature = delta.getFeature();
        Object oldValue = this.getOldValue(feature);
        if (oldValue instanceof CDOID && (object = this.findObjectByID(oldID = (CDOID)oldValue)) != null) {
            oldValue = object;
        }
        this.add(new CDODeltaNotificationImpl(this.object, 2, this.getEFeatureID(feature), oldValue, null));
    }

    public void visit(CDOClearFeatureDelta delta) {
        ArrayList list;
        EStructuralFeature feature = delta.getFeature();
        ArrayList oldValue = this.getOldValue(feature);
        if (oldValue instanceof List && !(list = (ArrayList)oldValue).isEmpty()) {
            list = new ArrayList(list);
            boolean changed = false;
            ListIterator<CDOObject> it = list.listIterator();
            while (it.hasNext()) {
                CDOID id;
                CDOObject oldObject;
                Object element = it.next();
                if (!(element instanceof CDOID) || (oldObject = this.findObjectByID(id = (CDOID)element)) == null) continue;
                it.set(oldObject);
                changed = true;
            }
            if (changed) {
                oldValue = list;
            }
        }
        this.add(new CDODeltaNotificationImpl(this.object, 6, this.getEFeatureID(feature), (Object)oldValue, null));
    }

    private CDOObject findObjectByID(CDOID id) {
        CDOObject object = this.view.getObject(id, false);
        if (object == null) {
            object = this.findDetachedObjectByID(id);
        }
        return object;
    }

    private CDOObject findDetachedObjectByID(CDOID id) {
        if (this.detachedObjects != null) {
            for (CDOObject object : this.detachedObjects) {
                if (!id.equals(object.cdoID())) continue;
                return object;
            }
        }
        return null;
    }

    public void visit(CDOContainerFeatureDelta delta) {
        CDOID oldID;
        CDOObject object;
        Object oldValue = null;
        if (this.oldRevision != null && (oldValue = this.oldRevision.getContainerID()) instanceof CDOID && (object = this.findObjectByID(oldID = (CDOID)oldValue)) != null) {
            oldValue = object;
        }
        this.add(new CDODeltaNotificationImpl(this.object, 1, (EStructuralFeature)EcorePackage.eINSTANCE.eContainmentFeature(), oldValue, delta.getContainerID()));
    }

    protected void add(CDODeltaNotificationImpl newNotificaton) {
        int size;
        newNotificaton.setRevisionDelta(this.revisionDelta);
        if (this.notification.add((Notification)newNotificaton) && (size = this.notification.size()) > 1) {
            CDODeltaNotificationImpl previousNotification = (CDODeltaNotificationImpl)this.notification.get(size - 2);
            previousNotification.add(newNotificaton);
        }
    }

    private int getEFeatureID(EStructuralFeature eFeature) {
        return this.object.eClass().getFeatureID(eFeature);
    }

    private Object getOldValue(EStructuralFeature feature) {
        if (this.oldRevision == null) {
            return null;
        }
        return this.oldRevision.getValue(feature);
    }
}

