/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryResultIteratorImpl<T>
extends AbstractQueryIterator<T> {
    private Map<CDOID, CDOObject> detachedObjects;

    public CDOQueryResultIteratorImpl(CDOView view, CDOQueryInfo queryInfo) {
        super(view, queryInfo);
    }

    @Override
    public void close() {
        this.detachedObjects = null;
        super.close();
    }

    public T next() {
        return this.adapt(super.next());
    }

    protected T adapt(Object object) {
        if (object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id.isNull()) {
                return null;
            }
            CDOView view = this.getView();
            try {
                CDOObject cdoObject = view.getObject(id, true);
                return (T)CDOUtil.getEObject(cdoObject);
            }
            catch (ObjectNotFoundException ex) {
                if (view instanceof CDOTransaction) {
                    if (this.detachedObjects == null) {
                        CDOTransaction transaction = (CDOTransaction)view;
                        this.detachedObjects = transaction.getDetachedObjects();
                    }
                    CDOObject cdoObject = this.detachedObjects.get(id);
                    return (T)CDOUtil.getEObject(cdoObject);
                }
                return null;
            }
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            Object[] resolvedObjects = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                resolvedObjects[i] = objects[i] instanceof CDOID ? this.adapt(objects[i]) : objects[i];
                ++i;
            }
            return (T)resolvedObjects;
        }
        return (T)object;
    }

    @Override
    public List<T> asList() {
        ArrayList<Object> result = new ArrayList<Object>();
        while (super.hasNext()) {
            result.add(super.next());
        }
        return new QueryResultList(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryResultList
    implements EList<T> {
        private List<Object> objects;

        public QueryResultList(List<Object> objects) {
            this.objects = objects;
        }

        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        public T get(int index) {
            return CDOQueryResultIteratorImpl.this.adapt(this.objects.get(index));
        }

        public boolean isEmpty() {
            return this.objects.isEmpty();
        }

        public Iterator<T> iterator() {
            return new ECDOIDIterator(this.objects.iterator());
        }

        public void move(int newPosition, T object) {
            throw new UnsupportedOperationException();
        }

        public T move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection<? extends T> arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int arg0, Collection<? extends T> arg1) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public int lastIndexOf(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public ListIterator<T> listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator<T> listIterator(int arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public T remove(int arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException();
        }

        public T set(int arg0, T arg1) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.objects.size();
        }

        public List<T> subList(int arg0, int arg1) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            return this.toArray(array);
        }

        public <E> E[] toArray(E[] input) {
            int size = this.size();
            if (input.length < size) {
                input = (Object[])Array.newInstance(input.getClass(), size);
            }
            int i = 0;
            while (i < size) {
                input[i] = this.get(i);
                ++i;
            }
            if (input.length > size) {
                input[size] = null;
            }
            return input;
        }

        public String toString() {
            return this.objects.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ECDOIDIterator
        implements Iterator<T> {
            private Iterator<Object> iterator;

            public ECDOIDIterator(Iterator<Object> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                return CDOQueryResultIteratorImpl.this.adapt(this.iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

