/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.refactoring;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.findrefs.DefaultReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreReferenceFinder
extends DefaultReferenceFinder {
    @Inject
    public XcoreReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry) {
        super(indexData, serviceProviderRegistry);
    }

    public void findReferences(Iterable<URI> targetURIs, Iterable<URI> sourceResourceURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        super.findReferences(targetURIs, sourceResourceURIs, localResourceAccess, this.createFilteringReferenceAcceptor(referenceAcceptor), monitor);
    }

    public void findAllReferences(Iterable<URI> targetURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        super.findAllReferences(targetURIs, localResourceAccess, this.createFilteringReferenceAcceptor(referenceAcceptor), monitor);
    }

    protected IAcceptor<IReferenceDescription> createFilteringReferenceAcceptor(final IAcceptor<IReferenceDescription> referenceAcceptor) {
        final HashSet sourceURIEReferencePairs = Sets.newHashSet();
        return new IAcceptor<IReferenceDescription>(){

            public void accept(IReferenceDescription referenceDescription) {
                if (sourceURIEReferencePairs.add(Tuples.pair((Object)referenceDescription.getSourceEObjectUri(), (Object)referenceDescription.getEReference()))) {
                    referenceAcceptor.accept((Object)referenceDescription);
                }
            }
        };
    }
}

