/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.XcoreExtensions;
import org.eclipse.emf.ecore.xcore.generator.XcoreAppendable;
import org.eclipse.emf.ecore.xcore.generator.XcoreGeneratorImpl;
import org.eclipse.emf.ecore.xcore.mappings.XDataTypeMapping;
import org.eclipse.emf.ecore.xcore.mappings.XFeatureMapping;
import org.eclipse.emf.ecore.xcore.mappings.XOperationMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XcoreGenerator
implements IGenerator {
    @Inject
    private XcoreMapper mappings;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private Provider<XcoreGeneratorImpl> xcoreGeneratorImplProvider;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        EList _contents = resource.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        XPackage pack = (XPackage)_head;
        Iterable<EObject> _allContentsIterable = XcoreExtensions.allContentsIterable(pack);
        Iterable _filter = Iterables.filter(_allContentsIterable, XOperation.class);
        for (XOperation op : _filter) {
            boolean _notEquals_1;
            boolean _notEquals;
            XOperationMapping _mapping = this.mappings.getMapping(op);
            EOperation eOperation = _mapping.getEOperation();
            XBlockExpression body = op.getBody();
            boolean bl = _notEquals = !Objects.equal((Object)body, null);
            if (!_notEquals) continue;
            XOperationMapping _mapping_1 = this.mappings.getMapping(op);
            JvmOperation jvmOperation = _mapping_1.getJvmOperation();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)jvmOperation, null);
            if (!_notEquals_1) continue;
            XcoreAppendable appendable = this.createAppendable();
            appendable.declareVariable(jvmOperation, "this");
            JvmTypeReference _returnType = jvmOperation.getReturnType();
            Set _emptySet = Collections.emptySet();
            this.compiler.compile((XExpression)body, (ITreeAppendable)appendable, _returnType, _emptySet);
            String _string = appendable.toString();
            String _extractBody = this.extractBody(_string);
            EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)_extractBody);
        }
        Iterable<EObject> _allContentsIterable_1 = XcoreExtensions.allContentsIterable(pack);
        Iterable _filter_1 = Iterables.filter(_allContentsIterable_1, XStructuralFeature.class);
        for (XStructuralFeature feature : _filter_1) {
            boolean _notEquals;
            XFeatureMapping _mapping = this.mappings.getMapping(feature);
            EStructuralFeature eStructuralFeature = _mapping.getEStructuralFeature();
            XBlockExpression getBody = feature.getGetBody();
            boolean bl = _notEquals = !Objects.equal((Object)getBody, null);
            if (!_notEquals) continue;
            XFeatureMapping _mapping_1 = this.mappings.getMapping(feature);
            JvmOperation getter = _mapping_1.getGetter();
            XcoreAppendable appendable = this.createAppendable();
            JvmDeclaredType _declaringType = getter.getDeclaringType();
            appendable.declareVariable(_declaringType, "this");
            JvmTypeReference _returnType = getter.getReturnType();
            Set _emptySet = Collections.emptySet();
            this.compiler.compile((XExpression)getBody, (ITreeAppendable)appendable, _returnType, _emptySet);
            String _string = appendable.toString();
            String _extractBody = this.extractBody(_string);
            EcoreUtil.setAnnotation((EModelElement)eStructuralFeature, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"get", (String)_extractBody);
        }
        Iterable<EObject> _allContentsIterable_2 = XcoreExtensions.allContentsIterable(pack);
        Iterable _filter_2 = Iterables.filter(_allContentsIterable_2, XDataType.class);
        for (XDataType dataType : _filter_2) {
            boolean _notEquals_2;
            boolean _notEquals;
            XDataTypeMapping _mapping = this.mappings.getMapping(dataType);
            EDataType eDataType = _mapping.getEDataType();
            XBlockExpression createBody = dataType.getCreateBody();
            XDataTypeMapping _mapping_1 = this.mappings.getMapping(dataType);
            JvmOperation creator = _mapping_1.getCreator();
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)createBody, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _notEquals_1 = !Objects.equal((Object)creator, null);
                boolean bl3 = _and = _notEquals && _notEquals_1;
            }
            if (_and) {
                XcoreAppendable appendable = this.createAppendable();
                EList _parameters = creator.getParameters();
                JvmFormalParameter _get = (JvmFormalParameter)_parameters.get(0);
                appendable.declareVariable(_get, "it");
                JvmTypeReference _returnType = creator.getReturnType();
                Set _emptySet = Collections.emptySet();
                this.compiler.compile((XExpression)createBody, (ITreeAppendable)appendable, _returnType, _emptySet);
                String _string = appendable.toString();
                String _extractBody = this.extractBody(_string);
                EcoreUtil.setAnnotation((EModelElement)eDataType, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"create", (String)_extractBody);
            }
            XBlockExpression convertBody = dataType.getConvertBody();
            XDataTypeMapping _mapping_2 = this.mappings.getMapping(dataType);
            JvmOperation converter = _mapping_2.getConverter();
            boolean _and_1 = false;
            boolean bl4 = _notEquals_2 = !Objects.equal((Object)convertBody, null);
            if (!_notEquals_2) {
                _and_1 = false;
            } else {
                boolean _notEquals_3 = !Objects.equal((Object)converter, null);
                boolean bl5 = _and_1 = _notEquals_2 && _notEquals_3;
            }
            if (!_and_1) continue;
            XcoreAppendable appendable_1 = this.createAppendable();
            EList _parameters_1 = converter.getParameters();
            JvmFormalParameter _get_1 = (JvmFormalParameter)_parameters_1.get(0);
            appendable_1.declareVariable(_get_1, "it");
            JvmTypeReference _returnType_1 = converter.getReturnType();
            Set _emptySet_1 = Collections.emptySet();
            this.compiler.compile((XExpression)convertBody, (ITreeAppendable)appendable_1, _returnType_1, _emptySet_1);
            String _string_1 = appendable_1.toString();
            String _extractBody_1 = this.extractBody(_string_1);
            EcoreUtil.setAnnotation((EModelElement)eDataType, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"convert", (String)_extractBody_1);
        }
        EList _contents_1 = resource.getContents();
        Iterable _filter_3 = Iterables.filter((Iterable)_contents_1, GenModel.class);
        GenModel _head_1 = (GenModel)IterableExtensions.head((Iterable)_filter_3);
        this.generateGenModel(_head_1, fsa);
    }

    public XcoreAppendable createAppendable() {
        XcoreAppendable _xcoreAppendable = new XcoreAppendable();
        return _xcoreAppendable;
    }

    public String extractBody(String body) {
        String _substring;
        String _xblockexpression = null;
        String _xifexpression = null;
        boolean _startsWith = body.startsWith("\n");
        _xifexpression = _startsWith ? (_substring = body.substring(1)) : body;
        String result = _xifexpression;
        String _xifexpression_1 = null;
        boolean _startsWith_1 = result.startsWith("{\n");
        if (_startsWith_1) {
            String _substring_1;
            String _replace;
            String _xblockexpression_1 = null;
            result = _replace = result.replace("\n\t", "\n");
            int _length = result.length();
            int _minus = _length - 2;
            _xifexpression_1 = _xblockexpression_1 = (_substring_1 = result.substring(1, _minus));
        } else {
            _xifexpression_1 = result;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public Diagnostic generateGenModel(GenModel genModel, IFileSystemAccess fsa) {
        Diagnostic _generate;
        Diagnostic _xblockexpression = null;
        genModel.setCanGenerate(true);
        XcoreGeneratorImpl generator = (XcoreGeneratorImpl)((Object)this.xcoreGeneratorImplProvider.get());
        generator.setInput(genModel);
        generator.setFileSystemAccess(fsa);
        String _modelDirectory = genModel.getModelDirectory();
        generator.setModelDirectory(_modelDirectory);
        BasicMonitor _basicMonitor = new BasicMonitor();
        generator.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)_basicMonitor);
        BasicMonitor _basicMonitor_1 = new BasicMonitor();
        generator.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)_basicMonitor_1);
        BasicMonitor _basicMonitor_2 = new BasicMonitor();
        generator.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)_basicMonitor_2);
        BasicMonitor _basicMonitor_3 = new BasicMonitor();
        _xblockexpression = _generate = generator.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", (Monitor)_basicMonitor_3);
        return _xblockexpression;
    }
}

