/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.custom.core.internal.exception.CustomizationCatalogRuntimeException;
import org.eclipse.emf.facet.custom.core.internal.exported.ICustomizationPropertiesCatalogManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationPropertiesCatalog;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationcatalogFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.emf.catalog.CatalogSet;
import org.eclipse.emf.facet.util.emf.core.ICatalogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationPropertiesCatalogManager
implements ICatalogManager,
ICustomizationPropertiesCatalogManager {
    private CustomizationPropertiesCatalog catalog = CustomizationcatalogFactory.eINSTANCE.createCustomizationPropertiesCatalog();

    public boolean canBeManaged(EObject root) {
        return root instanceof FacetSet;
    }

    public void manage(EObject root) {
        if (!(root instanceof FacetSet)) {
            throw new CustomizationCatalogRuntimeException("Only facetSets must be stored in the customization properties catalog");
        }
        FacetSet customizationProperties = (FacetSet)root;
        this.catalog.getInstalledEntries().add((Object)customizationProperties);
    }

    public void setCatalogSet(CatalogSet catalogSet) {
        catalogSet.getCatalogs().add((Object)this.catalog);
    }

    @Override
    public List<FacetSet> getAllRegisteredCustomizationProperties() {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        for (EObject eObject : this.catalog.getInstalledEntries()) {
            if (eObject instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)eObject;
                result.add(facetSet);
                continue;
            }
            throw new RuntimeException("Only facetSets must be stored in the customization properties catalog");
        }
        return result;
    }

    @Override
    public List<FacetOperation> getCustomizationPropertiesByName(String customPropertyName) {
        ArrayList<FacetOperation> result = new ArrayList<FacetOperation>();
        for (EObject facetSet : this.catalog.getInstalledEntries()) {
            TreeIterator iterator = facetSet.eAllContents();
            while (iterator.hasNext()) {
                FacetOperation customizationProperty;
                EObject eObject = (EObject)iterator.next();
                if (!(eObject instanceof FacetOperation) || !customPropertyName.equals((customizationProperty = (FacetOperation)eObject).getName())) continue;
                result.add(customizationProperty);
            }
        }
        return result;
    }
}

