/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CastUtils {
    private CastUtils() {
    }

    public static <T> List<T> castToExpectedListType(Object value, Class<T> expectedType, boolean checkTypeOfAllListElements) throws UnmatchingExpectedTypeException {
        if (!(value instanceof List)) {
            throw new UnmatchingExpectedTypeException("Expected " + List.class.getName() + ". Got " + value.getClass().getName() + ".");
        }
        List list = (List)value;
        if (checkTypeOfAllListElements) {
            CastUtils.checkTypeOfAllListElements(list, expectedType);
        }
        return list;
    }

    public static <T> T castToExpectedType(Object value, Class<T> expectedType) throws UnmatchingExpectedTypeException {
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new UnmatchingExpectedTypeException("Type mismatch. Expected: " + expectedType.getClass().getName() + ", got " + value.getClass().getName(), e);
        }
    }

    public static void checkTypeOfAllListElements(List<?> list, Class<?> expectedType) throws UnmatchingExpectedTypeException {
        if (expectedType == null) {
            return;
        }
        Iterator<?> iterator = list.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ++index;
            if (object == null || expectedType.isInstance(object)) continue;
            throw new UnmatchingExpectedTypeException("Type mismatch at index " + index, expectedType, object);
        }
    }
}

