/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.utils.BuildPropertiesUtils;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Deprecated
public final class PluginUtils {
    private PluginUtils() {
    }

    public static boolean isRegistered(IFile elementFile, String extensionPoint) {
        IProject project = elementFile.getProject();
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        if (pluginModel != null) {
            IPluginExtension[] extensions;
            IPluginExtension[] iPluginExtensionArray = extensions = pluginModel.getExtensions().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension pluginExtension = iPluginExtensionArray[n2];
                if (extensionPoint.equals(pluginExtension.getPoint())) {
                    IPluginObject[] children;
                    IPluginObject[] iPluginObjectArray = children = pluginExtension.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginObject child = iPluginObjectArray[n4];
                        if (child instanceof IPluginElement) {
                            IPluginAttribute[] attributes;
                            IPluginElement pluginElement = (IPluginElement)child;
                            IPluginAttribute[] iPluginAttributeArray = attributes = pluginElement.getAttributes();
                            int n5 = attributes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IFile file;
                                String strFile;
                                IPluginAttribute pluginAttribute = iPluginAttributeArray[n6];
                                if ("file".equalsIgnoreCase(pluginAttribute.getName()) && (strFile = pluginAttribute.getValue()) != null && strFile.length() > 0 && (file = project.getFile(strFile)).exists() && elementFile.equals((Object)file)) {
                                    return true;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static void register(IFile file, String extensionPointId, String elementName) {
        if (PluginUtils.isRegistered(file, extensionPointId)) {
            return;
        }
        IPath filePath = file.getFullPath().removeFirstSegments(1);
        IProject project = file.getProject();
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(pluginXML.getLocation().toOSString());
                Element root = doc.getDocumentElement();
                Text whitespace = doc.createTextNode("   ");
                root.appendChild(whitespace);
                Element extensionNode = doc.createElement("extension");
                Attr pointAttr = doc.createAttribute("point");
                pointAttr.setValue(extensionPointId);
                extensionNode.getAttributes().setNamedItem(pointAttr);
                root.appendChild(extensionNode);
                Element elementNode = doc.createElement(elementName);
                Attr fileAttr = doc.createAttribute("file");
                fileAttr.setValue(filePath.toString());
                elementNode.getAttributes().setNamedItem(fileAttr);
                extensionNode.appendChild(elementNode);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setAttribute("indent-number", new Integer(3));
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                byte[] byteArray = xmlString.getBytes("UTF-8");
                pluginXML.setContents((InputStream)new ByteArrayInputStream(byteArray), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        } else {
            try {
                String content = NLS.bind((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n   <extension point=\"{0}\">\n      <{1} file=\"{2}\"/>\n   </extension>\n</plugin>\n", (Object[])new Object[]{extensionPointId, elementName, filePath.toString()});
                byte[] byteArray = content.getBytes("UTF-8");
                pluginXML.create((InputStream)new ByteArrayInputStream(byteArray), true, (IProgressMonitor)new NullProgressMonitor());
                try {
                    BuildPropertiesUtils.addToBuild(pluginXML);
                }
                catch (Exception e) {
                    Logger.logError(e, "Error adding file " + pluginXML.getFullPath() + " to the build.properties", null);
                }
            }
            catch (Exception e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        }
    }
}

