/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.emf.facet.infra.query.core.internal.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;

public class ModelQuerySetName extends AbstractModelConstraint {

	@Override
	public IStatus validate(final IValidationContext ctx) {
		ModelQuerySet modelQuerySet = (ModelQuerySet) ctx.getTarget();
		EMFEventType eType = ctx.getEventType();
		if (eType == EMFEventType.NULL) {
			String lastSegment = modelQuerySet.eResource().getURI().lastSegment();
			String filename;
			if (lastSegment.endsWith(".querySet")) { //$NON-NLS-1$
				filename = lastSegment;
			} else {
				filename = lastSegment + ".querySet"; //$NON-NLS-1$
			}
			if (!filename.equals(modelQuerySet.getName() + ".querySet")) { //$NON-NLS-1$
				return ctx.createFailureStatus(filename, modelQuerySet.getName());
			}
		}
		return ctx.createSuccessStatus();
	}

}
