/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.core.internal;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.util.core.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.facet.infra.query.core";
    private static Activator plugin;
    private final HashMap<String, Bundle> installedBundle = new HashMap();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.uninstallTmpBundles();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void uninstallTmpBundles() {
        for (Bundle bundle : this.installedBundle.values()) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                Status status = new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public Bundle installBundle(IProject project) {
        Bundle bundle = null;
        try {
            String projectUri = project.getLocation().toFile().toURI().toString();
            projectUri = projectUri.replaceAll("%20", " ");
            if (this.installedBundle.containsKey(projectUri)) {
                this.installedBundle.get(projectUri).uninstall();
            } else {
                Bundle localBundle = Platform.getBundle((String)project.getName());
                if (localBundle != null) {
                    localBundle.uninstall();
                }
            }
            bundle = Activator.getDefault().getBundle().getBundleContext().installBundle(projectUri);
            if (bundle == null) {
                throw new RuntimeException();
            }
            this.installedBundle.put(projectUri, bundle);
        }
        catch (Exception e) {
            String message = "Failed to load bundle: " + project.getName();
            Logger.logError((Throwable)e, (String)message, (Plugin)Activator.getDefault());
        }
        Logger.logInfo((String)("Bundle loaded: " + project.getName()), (Plugin)Activator.getDefault());
        return bundle;
    }
}

