/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 333652 Extension point offering the possibility to declare an EPackage browser
 *******************************************************************************/
package org.eclipse.emf.facet.util.emf.ui.internal.utils;

import java.net.URL;

import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.ui.internal.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/** Provides icons for EMF Facet, and caches them. */
public class ImageProvider {
	private static final String EMFFACET_LOGO_URL = "icons/logoEmfFacetMini.gif"; //$NON-NLS-1$
	private static final String CATALOG_ICON_URL = "icons/catalog.png"; //$NON-NLS-1$

	private static ImageProvider instance = new ImageProvider();
	private Image emffacetLogo;
	private Image catalog = null;

	public static ImageProvider getInstance() {
		return ImageProvider.instance;
	}

	/**
	 * Create an image descriptor from a resource
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image descriptor
	 */
	private static ImageDescriptor createImageDescriptor(final String resourcePath) {
		final URL url = Activator.getDefault().getBundle()
				.getResource(resourcePath);
		if (url == null) {
			Logger.logError("resource not found: " + resourcePath, Activator //$NON-NLS-1$
					.getDefault());
			return ImageDescriptor.getMissingImageDescriptor();
		}
		return ImageDescriptor.createFromURL(url);
	}

	public Image getEmfFacetLogo() {
		if (this.emffacetLogo == null) {
			this.emffacetLogo = createImageDescriptor(
					ImageProvider.EMFFACET_LOGO_URL).createImage();
		}
		return this.emffacetLogo;
	}

	public static ImageDescriptor getEmfFacetLogoDescriptor() {
		return createImageDescriptor(ImageProvider.EMFFACET_LOGO_URL);
	}

	/** Return the icon representing a bidirectional link */
	public Image getCatalogIcon() {
		if (this.catalog == null) {
			this.catalog = createImageDescriptor(ImageProvider.CATALOG_ICON_URL)
					.createImage();
		}
		return this.catalog;
	}
}
