/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 340738 - Utility method to create a coherent tableInstance
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *    Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *    Vincent Lorenzo (CEA-LIST) - Bug 341328 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 344921 - Undo/Redo just after the creation of the table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.emf.facet.infra.browser.custom.util.UicustomUtil;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Factory;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration2.TableConfiguration2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

/**
 * 
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public final class NatTableWidgetUtils {

	private NatTableWidgetUtils() {
		// Prevent instantiation
	}

	public static TableInstance2 createTableInstance(final List<EObject> elements,
			final String description, final TableConfiguration tableConfiguration,
			final EObject context, final Object parameter) {

		TableInstance2 tableInstance = Tableinstance2Factory.eINSTANCE.createTableInstance2();
		tableInstance.setTableConfiguration(tableConfiguration);
		tableInstance.setContext(context);
		tableInstance.setParameter(parameter);
		for (EObject eObject : elements) {
			if (!tableInstance.getElements().contains(eObject)) {
				Row row = TableinstanceFactory.eINSTANCE.createRow();
				row.setElement(eObject);
				tableInstance.getRows().add(row);
			}
		}

		if (tableConfiguration != null) {
			for (Facet facet : tableConfiguration.getDefaultFacets()) {
				try {
					FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet(
							facet.getFacetSet().getName());
					Facet registeredFacet = facetSet.getFacet(facet.getName());
					if (registeredFacet != null) {
						if (!tableInstance.getFacets2().contains(registeredFacet)) {
							tableInstance.getFacets2().add(registeredFacet);
						}
					}
				} catch (Exception e) {
					// TODO should be externalized
					Logger.logError("The referenced facet:" + facet + " could not be loaded", //$NON-NLS-1$ //$NON-NLS-2$
							Activator.getDefault());
				}
			}
			for (MetamodelView custom : tableConfiguration.getDefaultCustomizations()) {
				if (!tableInstance.getCustomizations().contains(custom)) {
					tableInstance.getCustomizations().add(custom);
				}
			}

			MetamodelView defaultLocalCustomization = tableConfiguration
					.getDefaultLocalCustomization();
			if (defaultLocalCustomization != null
					&& !tableInstance.getLocalCustomizations().contains(defaultLocalCustomization)) {
				tableInstance.getLocalCustomizations().add(
						tableConfiguration.getDefaultLocalCustomization());
			}

			if (tableConfiguration instanceof TableConfiguration2) {
				TableConfiguration2 tableConfiguration2 = (TableConfiguration2) tableConfiguration;
				for (MetamodelView custom : tableConfiguration2.getDefaultLocalCustomizations()) {
					if (!tableInstance.getLocalCustomizations().contains(custom)) {
						tableInstance.getLocalCustomizations().add(custom);
					}
				}
			}
		}

		createColumns(tableInstance);

		tableInstance.setDescription(description);
		// we create the localCustomization if they don't exists
		// we store the nsURI which have been already added in the local
		// customization
		Set<EPackage> alreadyDone = new HashSet<EPackage>();
		List<EStructuralFeature> allFeatures = getTableInstanceEStructuralFeatures(tableInstance);
		Iterator<EStructuralFeature> iter = allFeatures.iterator();
		while (iter.hasNext()) {
			EStructuralFeature currentF = iter.next();
			EObject container = currentF.eContainer();
			if (container != null) {
				container = container.eContainer();
			}
			if (container instanceof EPackage) {
				if (!alreadyDone.contains(container)) {
					if (UicustomUtil.getMetamodelViewByEPackage(
							tableInstance.getLocalCustomizations(), (EPackage) container) == null) {
						// we create this localCustomization
						MetamodelView metamodelView = UicustomFactory.eINSTANCE
								.createMetamodelView();
						metamodelView.setMetamodelURI(((EPackage) container).getNsURI());
						metamodelView.setAllQuerySetsAvailable(false);
						tableInstance.getLocalCustomizations().add(metamodelView);
						alreadyDone.add((EPackage) container);

					}
				}
			}
		}

		// we create localCustomization for FacetColumn
		for (Facet current : tableInstance.getFacets2()) {
			EObject container = current.eContainer();
			if (container instanceof EPackage) {
				if (!alreadyDone.contains(container)) {
					if (UicustomUtil.getMetamodelViewByEPackage(
							tableInstance.getLocalCustomizations(), (EPackage) container) == null) {
						// we create this localCustomization
						MetamodelView metamodelView = UicustomFactory.eINSTANCE
								.createMetamodelView();
						metamodelView.setMetamodelURI(((EPackage) container).getNsURI());
						metamodelView.setAllQuerySetsAvailable(false);
						tableInstance.getLocalCustomizations().add(metamodelView);
						alreadyDone.add((EPackage) container);

					}
				}
			}
		}


		//we add all the local customization to the customization, at the beginning of the list
		if (!tableInstance.getLocalCustomizations().isEmpty()) {
			tableInstance.getCustomizations().addAll(0, tableInstance.getLocalCustomizations());
		}
		return tableInstance;
	}

	public static QueryTableInstance createQueryTableInstance(final List<ModelQueryResult> results,
			final TableConfiguration tableConfiguration, final EObject context, final Object parameter) {
		QueryTableInstance2 queryTableInstance = Tableinstance2Factory.eINSTANCE
				.createQueryTableInstance2();
		queryTableInstance.getQueryResults2().addAll(results);
		queryTableInstance.setTableConfiguration(tableConfiguration);
		queryTableInstance.setContext(context);
		queryTableInstance.setParameter(parameter);
		for (ModelQueryResult result : results) {
			if (result.getValue() instanceof Collection<?>) {
				Collection<?> collection = (Collection<?>) result.getValue();
				for (Object object : collection) {
					createQueryRow(queryTableInstance, result, object);
				}
			} else {
				createQueryRow(queryTableInstance, result, result.getValue());
			}
		}
		createColumns(queryTableInstance);
		return queryTableInstance;
	}

	private static void createQueryRow(final QueryTableInstance queryTableInstance,
			final ModelQueryResult result, final Object object) {
		if (object instanceof EObject) {
			EObject eObject = (EObject) object;
			if (!queryTableInstance.getElements().contains(eObject)) {
				EObjectQueryRow row = Tableinstance2Factory.eINSTANCE.createEObjectQueryRow();
				row.setElement(eObject);
				row.setQueryResult(result);
				queryTableInstance.getRows().add(row);
			}
		} else {
			PrimitiveTypeQueryRow row = Tableinstance2Factory.eINSTANCE
					.createPrimitiveTypeQueryRow();
			row.setElement(result);
			row.setQueryResult(result);
			row.setValue(object);
			queryTableInstance.getRows().add(row);
		}
	}

	private static void createColumns(final TableInstance tableInstance) {
		List<EStructuralFeature> features = getTableInstanceEStructuralFeatures(tableInstance);

		if (tableInstance instanceof QueryTableInstance) {
			tableInstance.getColumns().add(TableinstanceFactory.eINSTANCE.createContextColumn());
			for (Row row : tableInstance.getRows()) {
				if (row instanceof PrimitiveTypeQueryRow) {
					tableInstance.getColumns().add(
							Tableinstance2Factory.eINSTANCE.createValueColumn());
					break;
				}
			}
		} else {
			tableInstance.getColumns().add(
					TableinstanceFactory.eINSTANCE.createDefaultLabelColumn());

			tableInstance.getColumns().add(TableinstanceFactory.eINSTANCE.createMetaClassColumn());

			tableInstance.getColumns().add(TableinstanceFactory.eINSTANCE.createEContainerColumn());
		}

		for (final EStructuralFeature feature : features) {
			if (feature instanceof EReference) {
				ReferenceColumn referenceColumn = TableinstanceFactory.eINSTANCE
						.createReferenceColumn();
				referenceColumn.setReference((EReference) feature);
				tableInstance.getColumns().add(referenceColumn);

			} else if (feature instanceof EAttribute) {
				AttributeColumn attributeColumn = TableinstanceFactory.eINSTANCE
						.createAttributeColumn();
				attributeColumn.setAttribute((EAttribute) feature);
				tableInstance.getColumns().add(attributeColumn);
			}
		}
		if (tableInstance instanceof TableInstance2) {
			final FacetContext facetContext = new FacetContext();
			facetContext.addFacets(((TableInstance2) tableInstance).getFacets2());
			final Set<EReference> eReferences = new HashSet<EReference>();
			final Set<EAttribute> eAttributes = new HashSet<EAttribute>();
			List<IStatus> statusList = new ArrayList<IStatus>();
			for (EObject eObject : tableInstance.getElements()) {
				try {
					eAttributes.addAll(facetContext.getAttributes(eObject));
					eReferences.addAll(facetContext.getReferences(eObject));
				} catch (ModelQueryException e) {
					IStatus status = new Status(
							IStatus.ERROR,
							Activator.PLUGIN_ID,
							"An exception has occurred while retrieving structural features of:" + eObject, e); //$NON-NLS-1$
					statusList.add(status);
				}
			}
			if (!statusList.isEmpty()) {
				IStatus globalStatus = new MultiStatus(
						Activator.PLUGIN_ID,
						0,
						"An exception has occurred while retrieving structural features of the eObjects", //$NON-NLS-1$
						new Exception());
				Logger.logError(new CoreException(globalStatus), Activator.getDefault());
				MessageDialog.openError(Display.getCurrent().getActiveShell(),
						"Failed to load facets", //$NON-NLS-1$
						"Some facets failed to load. See Error Log for more details."); //$NON-NLS-1$
				// TODO Those strings have to be externalized
			}
			for (EAttribute eAttribute : eAttributes) {
				FacetAttributeColumn facetAttributeColumn = TableinstanceFactory.eINSTANCE
						.createFacetAttributeColumn();
				facetAttributeColumn.setAttribute((FacetAttribute) eAttribute);
				tableInstance.getColumns().add(facetAttributeColumn);
			}

			for (EReference eReference : eReferences) {
				FacetReferenceColumn facetReferenceColumn = TableinstanceFactory.eINSTANCE
						.createFacetReferenceColumn();
				facetReferenceColumn.setReference((FacetReference) eReference);
				tableInstance.getColumns().add(facetReferenceColumn);
			}
		}
	}


	private static List<EStructuralFeature> getTableInstanceEStructuralFeatures(final TableInstance tableInstance) {
		List<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
		if (!tableInstance.getElements().isEmpty()) {
			for (EObject eObject : tableInstance.getElements()) {
				if (eObject != null
						&& !(eObject instanceof ModelQueryResult && tableInstance instanceof QueryTableInstance)) {
					for (EStructuralFeature eStructuralFeature : eObject.eClass()
							.getEAllStructuralFeatures()) {
						if (!features.contains(eStructuralFeature)) {
							features.add(eStructuralFeature);
						}
					}
				}
			}
		}
		return features;
	}

}
