/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331520 - view query result in NatTable - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332438 - NatTable : table type
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - The user must be able to save which EMF objects are contained in a table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.queryDisplayers;

import java.util.List;

import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.infra.query.ui.views.queryExecution.QueryResultDisplayer;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class NatTableEditorQueryResultDisplayer implements QueryResultDisplayer {

	public NatTableEditorQueryResultDisplayer() {
		// nothing
	}

	public void displayQueryResult(final List<ModelQueryResult> result) {
		try {
			NatTableEditorFactory.getInstance().openOnQueryResult(result, null);
		} catch (UnsatisfiedConfigurationConstraint e) {
			Logger.logError(e, Activator.getDefault());
		}
	}

}
