/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditor;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditorInput;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableEditorFactory
implements ITableEditorFactory {
    private static NatTableEditorFactory instance;

    protected NatTableEditorFactory() {
    }

    public static NatTableEditorFactory getInstance() {
        if (instance == null) {
            instance = new NatTableEditorFactory();
        }
        return instance;
    }

    @Override
    public void openOn(List<EObject> elements, EditingDomain editingDomain, String description, TableConfiguration tableConfig, EObject context, Object parameter) {
        Table tableInstance = TableWidgetUtils.createTableInstance(elements, (String)description, (TableConfiguration)tableConfig, (EObject)context, (Object)parameter);
        this.openOn(tableInstance, editingDomain);
    }

    @Override
    public void openOn(Table input, EditingDomain editingDomain) {
        if (input instanceof NavigationTable) {
            this.openOnQueryResult(null, (NavigationTable)input);
        } else {
            TableEditorInput tableEditorInput = new TableEditorInput(input, editingDomain);
            NatTableEditorFactory.openOn(tableEditorInput);
        }
    }

    private static void openOn(final TableEditorInput input) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)TableEditor.getEditorId(), (boolean)true);
                }
                catch (PartInitException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
    }

    public void openOnQueryResult(List<ETypedElementResult> result, ETypedElement modelQuery) {
        NavigationTable queryTableInstance = TableWidgetUtils.createQueryTableInstance(result, null, null, null);
        this.openOnQueryResult(modelQuery, queryTableInstance);
    }

    private void openOnQueryResult(ETypedElement modelQuery, NavigationTable queryTableInstance) {
        String queryName;
        String description;
        int nElements = 0;
        for (ETypedElementResult mqr : queryTableInstance.getQueryResults()) {
            if (!(FacetUtils.getResultValue((ETypedElementResult)mqr) instanceof Collection)) continue;
            Collection collection = (Collection)FacetUtils.getResultValue((ETypedElementResult)mqr);
            nElements += collection.size();
        }
        if (modelQuery == null) {
            description = nElements > 1 ? NLS.bind((String)Messages.NatTableEditorFactory_queryResults, (Object)nElements) : NLS.bind((String)Messages.NatTableEditorFactory_queryResult, (Object)nElements);
            queryName = Messages.NatTableEditorFactory_aQuery;
        } else {
            queryName = modelQuery.getName();
            description = NLS.bind((String)Messages.NatTableEditorFactory_resultsForQuery, (Object)queryName, (Object)nElements);
        }
        queryTableInstance.setDescription(description);
        TableEditorInput input = new TableEditorInput((Table)queryTableInstance, null){

            public String getName() {
                return queryName;
            }
        };
        NatTableEditorFactory.openOn(input);
    }
}

