/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.io.File;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.URIEditorInputFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.osgi.framework.Bundle;

public class URIEditorInput
implements IEditorInput,
IPersistableElement {
    private URI uri;
    private String name;
    protected static final String BUNDLE_TAG = "bundle";
    protected static final String CLASS_TAG = "class";
    protected static final String URI_TAG = "uri";
    protected static final String NAME_TAG = "name";

    public URIEditorInput(URI uri) {
        this.uri = uri;
    }

    public URIEditorInput(URI uri, String name) {
        this.uri = uri;
        this.name = name;
    }

    public URIEditorInput(IMemento memento) {
        this.loadState(memento);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof URIEditorInput && this.uri.equals((Object)((URIEditorInput)o).getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean exists() {
        if (this.getURI().isFile()) {
            return new File(this.getURI().toFileString()).exists();
        }
        return false;
    }

    public String getName() {
        if (this.name == null) {
            URI uri = this.getURI();
            return URI.decode((String)(uri.isHierarchical() && uri.lastSegment() != null ? uri.lastSegment() : uri.toString()));
        }
        return this.name;
    }

    public String getToolTipText() {
        return this.getURI().toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return URIEditorInputFactory.ID;
    }

    protected String getBundleSymbolicName() {
        return CommonUIPlugin.getPlugin().getSymbolicName();
    }

    static URIEditorInput create(IMemento memento) {
        String bundleSymbolicName = memento.getString(BUNDLE_TAG);
        String className = memento.getString(CLASS_TAG);
        try {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            Class theClass = bundle.loadClass(className);
            Constructor constructor = theClass.getConstructor(IMemento.class);
            return (URIEditorInput)constructor.newInstance(memento);
        }
        catch (Exception exception) {
            CommonUIPlugin.INSTANCE.log(exception);
            return new URIEditorInput(memento);
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(BUNDLE_TAG, this.getBundleSymbolicName());
        memento.putString(CLASS_TAG, this.getClass().getName());
        memento.putString(URI_TAG, this.uri.toString());
        memento.putString(NAME_TAG, this.name);
    }

    protected void loadState(IMemento memento) {
        this.uri = URI.createURI((String)memento.getString(URI_TAG));
        this.name = memento.getString(NAME_TAG);
    }
}

