/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CatalogExtensionPointReader {
    CatalogExtensionPointReader() {
    }

    public List<CatalogDescriptor> getCatalogDescriptors() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.epp.mpc.ui", "catalog");
        if (extensionPoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<CatalogDescriptor> descriptors = new ArrayList<CatalogDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("catalog")) {
                try {
                    String selfContained;
                    String urlText = element.getAttribute("url");
                    if (urlText == null || urlText.trim().length() == 0) {
                        throw new Exception(Messages.CatalogExtensionPointReader_urlRequired);
                    }
                    URL url = new URL(urlText);
                    String label = element.getAttribute("label");
                    if (label == null || label.trim().length() == 0) {
                        throw new Exception(Messages.CatalogExtensionPointReader_labelRequired);
                    }
                    CatalogDescriptor descriptor = new CatalogDescriptor(url, label);
                    descriptor.setDescription(element.getAttribute("description"));
                    String icon = element.getAttribute("icon");
                    if (icon != null) {
                        URL iconResource = Platform.getBundle((String)element.getContributor().getName()).getResource(icon);
                        if (iconResource == null) {
                            throw new Exception(NLS.bind((String)Messages.CatalogExtensionPointReader_cannotFindResource, (Object)icon));
                        }
                        descriptor.setIcon(ImageDescriptor.createFromURL((URL)iconResource));
                    }
                    selfContained = (selfContained = element.getAttribute("selfContained")) == null || selfContained.trim().length() == 0 ? "true" : selfContained.trim();
                    descriptor.setInstallFromAllRepositories(Boolean.valueOf(selfContained) == false);
                    String dependenciesRepository = element.getAttribute("dependenciesRepository");
                    if (dependenciesRepository != null && dependenciesRepository.trim().length() > 0) {
                        URL repository = new URL(dependenciesRepository);
                        repository.toURI();
                        descriptor.setDependenciesRepository(repository);
                    }
                    if (!descriptors.contains(descriptor)) {
                        descriptors.add(descriptor);
                    }
                }
                catch (Exception e) {
                    MarketplaceClientUi.error(NLS.bind((String)Messages.CatalogExtensionPointReader_cannotRegisterCatalog_bundle_reason, (Object)element.getContributor().getName(), (Object)e.getMessage()), e);
                }
            }
            ++n2;
        }
        return descriptors;
    }
}

