/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.internal.STextDelimsEsc;

public class STextEmail
extends STextDelimsEsc {
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;

    public STextEmail() {
        super("<>.:,;@");
    }

    public int getDirection(ISTextExpert expert, String text) {
        return this.getDirection(expert, text, new STextCharTypes(expert, text));
    }

    public int getDirection(ISTextExpert expert, String text, STextCharTypes charTypes) {
        String language = expert.getEnvironment().getLanguage();
        if (!language.equals("ar")) {
            return 0;
        }
        int domainStart = text.indexOf(64);
        if (domainStart < 0) {
            domainStart = 0;
        }
        int i = domainStart;
        while (i < text.length()) {
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 2 || charType == 1) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int getSpecialsCount(ISTextExpert expert) {
        return 2;
    }

    protected String getDelimiters() {
        return "()\"\"";
    }
}

