/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectResolver;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJWeavingService
implements IWeavingService {
    private List<Definition> aspectDefinitions;
    private BundleDescription bundleDescription;
    private boolean enabled;
    private String namespaceAddOn;
    private OSGiWeavingAdaptor weavingAdaptor;
    private OSGiWeavingContext weavingContext;

    public AspectJWeavingService() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("- WeavingService.<init>");
        }
    }

    public AspectJWeavingService(ClassLoader loader, Bundle bundle, State state, BundleDescription bundleDescription, ISupplementerRegistry supplementerRegistry, AspectAdmin aspectAdmin) {
        this.bundleDescription = bundleDescription;
        AspectResolver aspectResolver = new AspectResolver(state, supplementerRegistry, aspectAdmin, AspectJWeavingStarter.getDefault().getContext());
        AspectConfiguration aspectConfig = aspectResolver.resolveAspectsFor(bundle, bundleDescription);
        this.namespaceAddOn = aspectConfig.getFingerprint();
        this.aspectDefinitions = aspectConfig.getAspectDefinitions();
        boolean bl = this.enabled = this.aspectDefinitions.size() > 0;
        if (this.enabled) {
            this.weavingContext = new OSGiWeavingContext(loader, bundleDescription, this.aspectDefinitions);
            this.weavingAdaptor = new OSGiWeavingAdaptor(loader, this.weavingContext, this.namespaceAddOn.toString());
        } else if (AspectJWeavingStarter.DEBUG) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + bundle.getSymbolicName() + "'");
        }
    }

    public void flushGeneratedClasses(ClassLoader loader) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            this.weavingAdaptor.flushGeneratedClasses();
        }
    }

    public boolean generatedClassesExistFor(ClassLoader loader, String className) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.generatedClassesExistFor(className);
        }
        return false;
    }

    public Map<String, byte[]> getGeneratedClassesFor(String className) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.getGeneratedClassesFor(className);
        }
        return new HashMap<String, byte[]>();
    }

    public String getKey() {
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("> WeavingService.getKey() bundle=" + this.bundleDescription.getSymbolicName());
        }
        String namespace = this.namespaceAddOn.toString();
        if (AspectJWeavingStarter.DEBUG) {
            System.out.println("< WeavingService.getKey() key='" + namespace + "'");
        }
        return namespace;
    }

    public byte[] preProcess(String name, byte[] classbytes, ClassLoader loader) throws IOException {
        if (this.enabled) {
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("> WeavingService.preProcess() bundle=" + this.bundleDescription.getSymbolicName() + ", name=" + name + ", bytes=" + classbytes.length);
            }
            this.ensureAdaptorInit();
            byte[] newBytes = this.weavingAdaptor.weaveClass(name, classbytes, false);
            if (AspectJWeavingStarter.DEBUG) {
                System.out.println("< WeavingService.preProcess() bytes=" + newBytes.length);
            }
            return newBytes;
        }
        return null;
    }

    private void ensureAdaptorInit() {
        this.weavingAdaptor.initialize();
    }
}

