/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.gemini.jpa.AnchorClassUtil;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.eclipse.gemini.jpa.PUnitInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FragmentUtil {
    public static final String FRAGMENT_PREFIX = "jpa$fragment.";
    Bundle providerBundle;
    public static final int ESTIMATED_FRAGMENT_SIZE = 2000;

    public FragmentUtil(Bundle providerBundle) {
        this.providerBundle = providerBundle;
    }

    public Bundle generateAndInstallFragment(Bundle b, Collection<PUnitInfo> infos, AnchorClassUtil anchorUtil) {
        GeminiUtil.debug("FragmentUtil generating fragment");
        List<String> packageNames = anchorUtil.uniquePackages(infos);
        List<byte[]> generatedClasses = anchorUtil.generateAnchorInterfaces(packageNames);
        Manifest manifest = this.generateFragmentManifest(b);
        byte[] fragment = this.createFragment(manifest, packageNames, anchorUtil.getAnchorClassName(), generatedClasses);
        GeminiUtil.debug("FragmentUtil finished generating fragment");
        Bundle installedFragment = this.installFragment(b, this.providerBundle, fragment);
        GeminiUtil.debug("FragmentUtil installed fragment bundle: ", (Object)installedFragment);
        return installedFragment;
    }

    public Manifest generateFragmentManifest(Bundle pUnitBundle) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        GeminiUtil.debug("Creating manifest ");
        attrs.putValue("Manifest-Version", "1.0");
        attrs.putValue("Bundle-ManifestVersion", "2");
        attrs.putValue("Bundle-Name", "JPA Fragment");
        attrs.putValue("Bundle-Description", "Generated JPA Fragment");
        String fragmentName = this.fragmentSymbolicName(pUnitBundle);
        attrs.putValue("Bundle-SymbolicName", fragmentName);
        String packageImport = "org.osgi.service.jpa,javax.persistence";
        attrs.putValue("Import-Package", packageImport);
        String hostVersion = GeminiUtil.bundleVersion(pUnitBundle);
        attrs.putValue("Bundle-Version", hostVersion);
        String fragmentHost = String.valueOf(pUnitBundle.getSymbolicName()) + ";bundle-version=" + hostVersion;
        attrs.putValue("Fragment-Host", fragmentHost);
        GeminiUtil.debug("FragmentUtil created manifest for ", (Object)fragmentName);
        for (Map.Entry<Object, Object> e : manifest.getMainAttributes().entrySet()) {
            GeminiUtil.debug("Manifest header: " + e.getKey(), (Object)(", value=" + e.getValue()));
        }
        return manifest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] createFragment(Manifest manifest, List<String> packageNames, String className, List<byte[]> generatedClasses) {
        byte[] byArray;
        GeminiUtil.debug("Creating fragment ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)bos, manifest);
            for (String p : packageNames) {
                JarEntry entry = new JarEntry(String.valueOf(GeminiUtil.formattedPackageString(p, '.', '/')) + className + ".class");
                jos.putNextEntry(entry);
                jos.write(generatedClasses.remove(0));
            }
            GeminiUtil.debug("Successfully created fragment ");
            jos.close();
            byArray = baos.toByteArray();
        }
        catch (Exception ex) {
            try {
                GeminiUtil.fatalError("Error creating fragment: ", ex);
            }
            catch (Throwable throwable) {
                GeminiUtil.close(jos);
                GeminiUtil.close(bos);
                GeminiUtil.close(baos);
                throw throwable;
            }
            GeminiUtil.close(jos);
            GeminiUtil.close(bos);
            GeminiUtil.close(baos);
            return null;
        }
        GeminiUtil.close(jos);
        GeminiUtil.close(bos);
        GeminiUtil.close(baos);
        return byArray;
    }

    public Bundle installFragment(Bundle pUnitBundle, Bundle providerBundle, byte[] bundleData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bundleData);
        String locationUrl = null;
        Bundle fragmentBundle = null;
        try {
            locationUrl = this.fragmentLocation(pUnitBundle);
            GeminiUtil.debug("Installing fragment: ", (Object)locationUrl);
            BundleContext ctx = providerBundle.getBundleContext();
            fragmentBundle = ctx.installBundle(locationUrl, (InputStream)bais);
        }
        catch (Exception ex) {
            GeminiUtil.fatalError("Could not install fragment: " + locationUrl + ": ", ex);
        }
        return fragmentBundle;
    }

    public String fragmentLocation(Bundle pUnitBundle) {
        return String.valueOf(this.fragmentSymbolicName(pUnitBundle)) + "_" + GeminiUtil.bundleVersion(pUnitBundle);
    }

    public String fragmentSymbolicName(Bundle b) {
        return FRAGMENT_PREFIX + b.getSymbolicName();
    }
}

