/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class Util {
    private Util() {
    }

    public static String deriveSanitizedFileName(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        char[] invalidCharacters = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            char[] cArray = invalidCharacters;
            int n = invalidCharacters.length;
            int n2 = 0;
            while (n2 < n) {
                char invalidChar = cArray[n2];
                if (c == invalidChar) {
                    c = '_';
                }
                ++n2;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static IFile nextUniqueFile(IFile file) {
        int n = 1;
        String extension = file.getFileExtension();
        String name = file.getFullPath().removeFileExtension().lastSegment();
        IFile newFile = file;
        while (newFile.exists()) {
            newFile = newFile.getParent().getFile((IPath)new Path(String.valueOf(name) + "_" + n++ + "." + extension));
        }
        return newFile;
    }

    public static boolean safeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

