/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.dt;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.internal.util.T;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.notification.DefaultNotificationService;
import org.eclipse.graphiti.notification.INotificationService;
import org.eclipse.graphiti.platform.AbstractExtension;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.platform.ga.IGraphicsAlgorithmRendererFactory;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;

public abstract class AbstractDiagramTypeProvider
extends AbstractExtension
implements IDiagramTypeProvider {
    private IToolBehaviorProvider[] availableToolBehaviorProviders = null;
    private Diagram diagram;
    private IDiagramEditor diagramEditor;
    private IFeatureProvider featureProvider;
    private INotificationService notificationService;
    private int currentToolBehaviorIndex = 0;

    public IToolBehaviorProvider[] getAvailableToolBehaviorProviders() {
        if (this.availableToolBehaviorProviders == null) {
            this.availableToolBehaviorProviders = new IToolBehaviorProvider[]{new DefaultToolBehaviorProvider(this)};
        }
        return this.availableToolBehaviorProviders;
    }

    public IToolBehaviorProvider getCurrentToolBehaviorProvider() {
        IToolBehaviorProvider ret = null;
        if (this.getAvailableToolBehaviorProviders().length > 0) {
            ret = this.getAvailableToolBehaviorProviders()[this.getCurrentToolBehaviorIndex()];
        }
        return ret;
    }

    public int getCurrentToolBehaviorIndex() {
        return this.currentToolBehaviorIndex;
    }

    public void setCurrentToolBehaviorIndex(int index) {
        if (this.currentToolBehaviorIndex != index) {
            if (index < 0 || index >= this.getAvailableToolBehaviorProviders().length) {
                throw new IllegalArgumentException("Index not valid");
            }
            this.currentToolBehaviorIndex = index;
            IDiagramEditor de = this.getDiagramEditor();
            de.refresh();
            de.refreshPalette();
        }
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public String getDiagramTitle() {
        String name = "";
        if (this.getDiagram() != null) {
            name = this.getDiagram().getName();
        }
        return name;
    }

    public IDiagramEditor getDiagramEditor() {
        return this.diagramEditor;
    }

    public IFeatureProvider getFeatureProvider() {
        if (this.featureProvider == null) {
            T.racer().error("featureProvider is null");
        }
        return this.featureProvider;
    }

    public void init(Diagram diagram, IDiagramEditor diagramEditor) {
        this.setDiagram(diagram);
        GraphitiInternal.getEmfService().wireDTPToDiagram(diagram, this);
        this.setDiagramEditor(diagramEditor);
    }

    private void setDiagramEditor(IDiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
    }

    private void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    protected void setFeatureProvider(IFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    public boolean isAutoUpdateAtRuntime() {
        return true;
    }

    public boolean isAutoUpdateAtRuntimeWhenEditorIsSaved() {
        return false;
    }

    public boolean isAutoUpdateAtStartup() {
        return false;
    }

    public boolean isAutoUpdateAtReset() {
        return true;
    }

    public void dispose() {
        if (this.getCurrentToolBehaviorProvider() != null) {
            this.getCurrentToolBehaviorProvider().dispose();
        }
        if (this.getFeatureProvider() != null) {
            this.getFeatureProvider().dispose();
        }
    }

    public INotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = new DefaultNotificationService(this);
        }
        return this.notificationService;
    }

    public Object[] getRelatedBusinessObjects(Object[] bos) {
        return new Object[0];
    }

    public IGraphicsAlgorithmRendererFactory getGraphicsAlgorithmRendererFactory() {
        return null;
    }

    public void postInit() {
    }

    public void resourceReloaded(Diagram diagram) {
        this.setDiagram(diagram);
    }

    public void resourcesSaved(Diagram diagram, Resource[] savedResources) {
    }
}

