/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.command;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.GFPreparableCommand;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.util.T;

public class CommandExec {
    private static int commandExecutionDepth2 = 0;
    private static CommandExec singleton = null;

    private CommandExec() {
    }

    public boolean executeCommand(ICommand command, TransactionalEditingDomain editingDomain) {
        boolean reallyTraceIt;
        long start = System.currentTimeMillis();
        String indent = "";
        boolean bl = reallyTraceIt = GFPreferences.getInstance().isCPUProfilingTraceActive() && ++commandExecutionDepth2 < 4;
        if (reallyTraceIt && T.racer().info()) {
            int i = 1;
            while (i < commandExecutionDepth2) {
                indent = String.valueOf(indent) + "  ";
                ++i;
            }
            if (commandExecutionDepth2 == 1) {
                T.racer().info("\n");
            }
            T.racer().info(String.valueOf(indent) + ">start CommandExec.executeCommand(command, connection) => openCommandGroup => " + command.getDescription() + " >");
        }
        CommandStack commandStack = editingDomain.getCommandStack();
        GFPreparableCommand gfRecordingCommand = new GFPreparableCommand(editingDomain, command);
        commandStack.execute((Command)gfRecordingCommand);
        boolean ret = gfRecordingCommand.getExecutionResult();
        long stop = System.currentTimeMillis();
        if (reallyTraceIt && T.racer().info()) {
            T.racer().info(String.valueOf(indent) + "<stop (" + (stop - start) + " ms) " + "CommandExec.executeCommand(command, connection) => closeCommandGroup => " + command.getDescription() + " <");
            if (commandExecutionDepth2 == 1) {
                T.racer().info("\n");
            }
        }
        --commandExecutionDepth2;
        return ret;
    }

    public static CommandExec getSingleton() {
        if (singleton == null) {
            singleton = new CommandExec();
        }
        return singleton;
    }

    public static void executeFeatureWithContext(IFeature feature, IContext context) {
        GenericFeatureCommandWithContext genericFeatureCommandWithContext = new GenericFeatureCommandWithContext(feature, context);
        TransactionalEditingDomain editingDomain = feature.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor().getEditingDomain();
        CommandExec.getSingleton().executeCommand(genericFeatureCommandWithContext, editingDomain);
    }
}

