/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal.zookeeper;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudUiActivator;
import org.eclipse.gyrex.admin.ui.cloud.internal.zookeeper.PathPatternFilter;
import org.eclipse.gyrex.admin.ui.cloud.internal.zookeeper.ZooKeeperData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class ZooKeeperExplorer
extends ViewPart {
    public static final String ID = "org.eclipse.gyrex.admin.ui.cloud.view.zookeeper";
    private FilteredTree filteredTree;
    private IAction refreshAction;

    private void createActions() {
        this.refreshAction = new Action(){

            public void run() {
                ZooKeeperExplorer.this.filteredTree.getViewer().setInput((Object)new ZooKeeperData((IPath)Path.ROOT, null));
            }
        };
        this.refreshAction.setId(ActionFactory.REFRESH.getId());
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh the tree!");
        this.refreshAction.setImageDescriptor(CloudUiActivator.getImageDescriptor("/icons/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(CloudUiActivator.getImageDescriptor("/icons/refresh_disabled.gif"));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        PathPatternFilter filter = new PathPatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.filteredTree = new FilteredTree(parent, 772, (PatternFilter)filter, true);
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        viewer.setComparator(new ViewerComparator());
        viewer.setInput(new Object());
        this.createActions();
        this.initToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setInput((Object)new ZooKeeperData((IPath)Path.ROOT, null));
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        if (this.refreshAction != null) {
            tm.add(this.refreshAction);
        }
    }

    public void setFocus() {
        this.filteredTree.setFocus();
    }

    static class ViewContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];

        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            return this.getElements(parent);
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ZooKeeperData) {
                return ((ZooKeeperData)parent).getChildren();
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof ZooKeeperData) {
                return ((ZooKeeperData)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ZooKeeperData) {
                return ((ZooKeeperData)element).hasChildren();
            }
            return false;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ZooKeeperData) {
                return ((ZooKeeperData)element).getLabel();
            }
            return super.getText(element);
        }
    }
}

