/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.application.Navigation;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.AdminPageRegistry;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;
import org.eclipse.gyrex.admin.ui.pages.FilteredAdminPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.events.BrowserHistoryEvent;
import org.eclipse.rwt.events.BrowserHistoryListener;
import org.eclipse.rwt.internal.widgets.JSExecutor;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApplication
implements IEntryPoint {
    private static final String GYREX_WEBSITE_URL = "http://eclipse.org/gyrex/";
    private static final int CONTENT_MIN_HEIGHT = 800;
    private static final int CENTER_AREA_WIDTH = 998;
    private static final Logger LOG = LoggerFactory.getLogger(AdminApplication.class);
    private Composite centerArea;
    private Navigation navigation;
    private Composite navBar;
    private final Map<String, AdminPage> pagesById = new HashMap<String, AdminPage>();
    private AdminPage currentPage;
    private Image logo;

    private static Label createHeadlineLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text.replace("&", "&&"));
        label.setData("org.eclipse.rwt.themeVariant", (Object)"pageHeadline");
        return label;
    }

    private static FormData createLogoFormData(Image logo) {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        return data;
    }

    private static FormData createNavBarFormData() {
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 5);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    public static Image getImage(Display display, String path) {
        ImageDescriptor imageDescriptor = AdminUiActivator.getImageDescriptor("img/" + path);
        return imageDescriptor.createImage((Device)display);
    }

    private static String getVersion() {
        Version version = AdminUiActivator.getInstance().getBundleVersion();
        StringBuilder resultBuffer = new StringBuilder(20);
        resultBuffer.append(version.getMajor());
        resultBuffer.append('.');
        resultBuffer.append(version.getMinor());
        resultBuffer.append('.');
        resultBuffer.append(version.getMicro());
        resultBuffer.append(" (Build ");
        resultBuffer.append(version.getQualifier());
        resultBuffer.append(')');
        return resultBuffer.toString();
    }

    private static void makeLink(Label control, final String url) {
        control.setCursor(control.getDisplay().getSystemCursor(21));
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JSExecutor.executeJS((String)("window.location.href = '" + url + "'"));
            }
        });
    }

    private void activate(AdminPage page, PageContribution contribution) {
        String historyText = StringUtils.isNotBlank((String)page.getTitleToolTip()) ? String.format("%s - %s - Gyrex Admin", contribution.getName(), page.getTitleToolTip()) : String.format("%s - Gyrex Admin", contribution.getName());
        RWT.getBrowserHistory().createEntry(contribution.getId(), historyText);
        Control[] controlArray = this.centerArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.createPage(page, contribution, this.centerArea);
        this.centerArea.layout(true, true);
        page.activate();
    }

    private void attachHistoryListener() {
        RWT.getBrowserHistory().addBrowserHistoryListener(new BrowserHistoryListener(){

            public void navigated(BrowserHistoryEvent event) {
                PageContribution contribution = AdminPageRegistry.getInstance().getPage(event.entryId);
                if (contribution != null) {
                    AdminApplication.this.openPage(contribution);
                }
            }
        });
    }

    private Composite createCenterArea(Composite parent, Control topControl, Control bottomControl) {
        Composite centerArea = new Composite(parent, 0);
        centerArea.setLayout((Layout)new FillLayout());
        centerArea.setLayoutData((Object)this.createCenterAreaFormData(topControl, bottomControl));
        centerArea.setData("org.eclipse.rwt.themeVariant", (Object)"centerArea");
        return centerArea;
    }

    private FormData createCenterAreaFormData(Control topAttachment, Control bottomAttachment) {
        FormData data = new FormData();
        data.top = new FormAttachment(topAttachment, 0, 1024);
        data.bottom = new FormAttachment(bottomAttachment, -10, 128);
        data.left = new FormAttachment(50, -489);
        data.width = 988;
        return data;
    }

    private Composite createContent(ScrolledComposite scrolledArea) {
        this.logo = AdminApplication.getImage(scrolledArea.getDisplay(), "gyrex/gyrex-juno.png");
        Composite comp = new Composite((Composite)scrolledArea, 0);
        comp.setLayout((Layout)new FormLayout());
        Composite header = this.createHeader(comp);
        header.setLayoutData((Object)this.createHeaderFormData(this.logo.getBounds().height));
        this.createContentBody(comp, header);
        return comp;
    }

    private void createContentBody(Composite parent, Composite header) {
        Composite separator = new Composite(parent, 0);
        separator.setData("org.eclipse.rwt.themeVariant", (Object)"mainContentAreaHeaderSeparator");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 2;
        separator.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        composite.setData("org.eclipse.rwt.themeVariant", (Object)"mainContentArea");
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)this.createContentBodyFormData((Control)separator));
        Composite footer = this.createFooter(composite);
        this.centerArea = this.createCenterArea(composite, (Control)separator, (Control)footer);
    }

    private FormData createContentBodyFormData(Control topControlToAttachTo) {
        FormData data = new FormData();
        data.top = new FormAttachment(topControlToAttachTo, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private Composite createFooter(Composite contentComposite) {
        Composite footer = new Composite(contentComposite, 0);
        footer.setLayout((Layout)new FormLayout());
        footer.setData("org.eclipse.rwt.themeVariant", (Object)"footer");
        footer.setLayoutData((Object)this.createFooterFormData());
        Label label = new Label(footer, 0);
        label.setData("org.eclipse.rwt.themeVariant", (Object)"footerLabel");
        label.setText("Admin Console " + AdminApplication.getVersion());
        label.setLayoutData((Object)this.createFooterLabelFormData(footer));
        return footer;
    }

    private FormData createFooterFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(100, -40);
        data.bottom = new FormAttachment(100);
        data.width = 986;
        return data;
    }

    private FormData createFooterLabelFormData(Composite footer) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, -10);
        data.right = new FormAttachment(100, -15);
        return data;
    }

    private Composite createHeader(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setData("org.eclipse.rwt.themeVariant", (Object)"header");
        comp.setBackgroundMode(1);
        comp.setLayout((Layout)new FormLayout());
        Composite headerCenterArea = this.createHeaderCenterArea(comp);
        Label logoLabel = new Label(headerCenterArea, 0);
        logoLabel.setImage(this.logo);
        logoLabel.setLayoutData((Object)AdminApplication.createLogoFormData(this.logo));
        AdminApplication.makeLink(logoLabel, GYREX_WEBSITE_URL);
        this.navigation = this.createNavigation(headerCenterArea);
        return comp;
    }

    private Composite createHeaderCenterArea(Composite parent) {
        Composite headerCenterArea = new Composite(parent, 0);
        headerCenterArea.setLayout((Layout)new FormLayout());
        headerCenterArea.setLayoutData((Object)this.createHeaderCenterAreaFormData());
        return headerCenterArea;
    }

    private FormData createHeaderCenterAreaFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = 998;
        return data;
    }

    private FormData createHeaderFormData(int height) {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = height;
        return data;
    }

    private Shell createMainShell(Display display) {
        Shell shell = new Shell(display, 8);
        shell.setMaximized(true);
        shell.setData("org.eclipse.rwt.themeVariant", (Object)"mainshell");
        return shell;
    }

    private Navigation createNavigation(Composite parent) {
        this.navBar = new Composite(parent, 0);
        this.navBar.setLayoutData((Object)AdminApplication.createNavBarFormData());
        this.navBar.setData("org.eclipse.rwt.themeVariant", (Object)"nav-bar");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.navBar.setLayout((Layout)layout);
        Navigation navigation = new Navigation(this.navBar){

            @Override
            protected void openPage(PageContribution page) {
                AdminApplication.this.openPage(page);
            }
        };
        return navigation;
    }

    private void createPage(AdminPage page, PageContribution contribution, Composite parent) {
        String title;
        Composite pageComp = new Composite(parent, 0);
        pageComp.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(1, false));
        GridData filterData = AdminUiUtil.createHorzFillData();
        if (page instanceof FilteredAdminPage) {
            Control filterControl = ((FilteredAdminPage)page).createFilterControl(pageComp);
            filterData.exclude = !filterControl.isVisible();
            filterControl.setLayoutData((Object)filterData);
        }
        if (StringUtils.isBlank((String)(title = page.getTitle()))) {
            title = contribution.getName();
        }
        if (StringUtils.isNotBlank((String)title)) {
            Label label = AdminApplication.createHeadlineLabel(pageComp, page.getTitle());
            GridData layoutData = new GridData();
            layoutData.verticalIndent = page instanceof FilteredAdminPage && !filterData.exclude ? 5 : 30;
            label.setLayoutData((Object)layoutData);
        }
        Composite contentComp = new Composite(pageComp, 0);
        contentComp.setLayoutData((Object)AdminUiUtil.createFillData());
        contentComp.setLayout((Layout)new FillLayout());
        page.createControl(contentComp);
        Control[] controlArray = contentComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getLayoutData() != null) {
                LOG.warn("Programming error in page {}: child composites ({}) should not make any assumptions about the parent layout!", (Object)contribution.getId(), (Object)child);
                child.setLayoutData(null);
            }
            ++n2;
        }
    }

    private ScrolledComposite createScrolledArea(Composite parent) {
        ScrolledComposite scrolledComp = new ScrolledComposite(parent, 768);
        scrolledComp.setMinHeight(800);
        scrolledComp.setMinWidth(998);
        scrolledComp.setExpandVertical(true);
        scrolledComp.setExpandHorizontal(true);
        return scrolledComp;
    }

    public int createUI() {
        Display display = new Display();
        Shell shell = this.createMainShell(display);
        shell.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledArea = this.createScrolledArea((Composite)shell);
        Composite content = this.createContent(scrolledArea);
        scrolledArea.setContent((Control)content);
        this.attachHistoryListener();
        shell.open();
        this.openInitialPage();
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                if (AdminApplication.this.currentPage != null) {
                    AdminApplication.this.deactivate(AdminApplication.this.currentPage);
                }
            }
        });
        return 0;
    }

    private void deactivate(AdminPage page) {
        page.deactivate();
    }

    private AdminPage getPage(PageContribution contribution) throws CoreException {
        if (!this.pagesById.containsKey(contribution.getId())) {
            this.pagesById.put(contribution.getId(), contribution.createPage());
        }
        return this.pagesById.get(contribution.getId());
    }

    private void openInitialPage() {
        PageContribution contribution = this.navigation.findInitialPage();
        if (contribution != null) {
            this.openPage(contribution);
        }
    }

    private void openPage(PageContribution contribution) {
        try {
            AdminPage page = this.getPage(contribution);
            if (page == null) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui", String.format("Page '%s' not found!", contribution.getId())), "Error Opening Page");
                return;
            }
            if (page == this.currentPage) {
                return;
            }
            if (this.currentPage != null) {
                this.deactivate(this.currentPage);
            }
            this.currentPage = page;
            this.navigation.selectNavigationEntry(contribution);
            this.activate(page, contribution);
        }
        catch (CoreException e) {
            Policy.getStatusHandler().show(e.getStatus(), "Error Opening Page");
            return;
        }
    }
}

