/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.application.DropDownMenu;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.AdminPageRegistry;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.CategoryContribution;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

abstract class DropDownNavigation
extends DropDownMenu {
    private final CategoryContribution category;
    private final List<PageContribution> pages;

    private static List<String> getItemLabels(List<PageContribution> pages) {
        ArrayList<String> list = new ArrayList<String>();
        for (PageContribution pageContribution : pages) {
            list.add(pageContribution.getName());
        }
        return list;
    }

    public DropDownNavigation(Composite parent, CategoryContribution category) {
        super(parent, category.getName(), "navigation");
        this.category = category;
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.pages = AdminPageRegistry.getInstance().getPages(category);
        Collections.sort(this.pages);
        this.createMenuItems(DropDownNavigation.getItemLabels(this.pages));
    }

    public PageContribution findFirstPage() {
        Iterator<PageContribution> iterator = this.pages.iterator();
        if (iterator.hasNext()) {
            PageContribution page = iterator.next();
            return page;
        }
        return null;
    }

    public CategoryContribution getCategory() {
        return this.category;
    }

    @Override
    protected void openItem(String item) {
        for (PageContribution page : this.pages) {
            if (!item.equals(page.getName())) continue;
            this.openPage(page);
            return;
        }
    }

    protected abstract void openPage(PageContribution var1);
}

