/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Shell;

public class NonBlockingMessageDialogs {
    private static String[] getButtonLabels(int kind) {
        String[] dialogButtonLabels;
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                dialogButtonLabels = new String[]{IDialogConstants.get().OK_LABEL};
                break;
            }
            case 5: {
                dialogButtonLabels = new String[]{IDialogConstants.get().OK_LABEL, IDialogConstants.get().CANCEL_LABEL};
                break;
            }
            case 3: {
                dialogButtonLabels = new String[]{IDialogConstants.get().YES_LABEL, IDialogConstants.get().NO_LABEL};
                break;
            }
            case 6: {
                dialogButtonLabels = new String[]{IDialogConstants.get().YES_LABEL, IDialogConstants.get().NO_LABEL, IDialogConstants.get().CANCEL_LABEL};
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return dialogButtonLabels;
    }

    private static void open(int kind, Shell parent, String title, String message, final DialogCallback callback) {
        String[] buttonLabels = NonBlockingMessageDialogs.getButtonLabels(kind);
        MessageDialog dialog = new MessageDialog(parent, title, null, message, kind, buttonLabels, 0){

            public boolean close() {
                boolean result = super.close();
                if (callback != null) {
                    callback.dialogClosed(this.getReturnCode());
                }
                return result;
            }

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    public static void openConfirm(Shell parent, String title, String message, DialogCallback callback) {
        NonBlockingMessageDialogs.open(5, parent, title, message, callback);
    }

    public static void openError(Shell parent, String title, String message, DialogCallback callback) {
        NonBlockingMessageDialogs.open(1, parent, title, message, callback);
    }

    public static void openInformation(Shell parent, String title, String message, DialogCallback callback) {
        NonBlockingMessageDialogs.open(2, parent, title, message, callback);
    }

    public static void openQuestion(Shell parent, String title, String message, DialogCallback callback) {
        NonBlockingMessageDialogs.open(3, parent, title, message, callback);
    }

    public static void openWarning(Shell parent, String title, String message, DialogCallback callback) {
        NonBlockingMessageDialogs.open(4, parent, title, message, callback);
    }
}

