/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class LinkDialogField
extends DialogField {
    private String fText = "";
    private Link fLinkControl;

    protected static GridData gridDataForLink(int span) {
        GridData gd = new GridData(4, 2, false, false);
        gd.horizontalSpan = span;
        return gd;
    }

    protected Link createLinkControl(Composite parent) {
        Link link = new Link(parent, 16448);
        link.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        return link;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)LinkDialogField.gridDataForLabel(1));
        Link link = this.getLinkControl(parent);
        link.setLayoutData((Object)LinkDialogField.gridDataForLink(nColumns - 1));
        return new Control[]{label, link};
    }

    public Link getLinkControl(Composite parent) {
        if (this.fLinkControl == null) {
            this.assertCompositeNotNull(parent);
            this.fLinkControl = this.createLinkControl(parent);
            this.fLinkControl.setText(this.fText);
            this.fLinkControl.setFont(parent.getFont());
            this.fLinkControl.setEnabled(this.isEnabled());
        }
        return this.fLinkControl;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fLinkControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fLinkControl)) {
            this.fLinkControl.setFocus();
        }
        return true;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fLinkControl)) {
            this.fLinkControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fLinkControl)) {
            this.fLinkControl.setText(text);
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fLinkControl)) {
            this.fLinkControl.setEnabled(this.isEnabled());
        }
    }
}

