/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.internal.opsmode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.internal.opsmode.OperationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpsMode {
    String PROPERTY_KEY_OPS_MODE = "gyrex.operation.mode";
    private static final Logger LOG = LoggerFactory.getLogger(OpsMode.class);
    private static final String STATE_FILE_NAME = "operationMode";
    private static final String DEVELOPMENT = "development";
    private static final String PRODUCTION = "production";
    private final AtomicReference<OperationMode> operationMode = new AtomicReference();

    private static File getInstanceStateFile() {
        return Platform.getStateLocation(BootActivator.getInstance().getBundle()).append(STATE_FILE_NAME).toFile();
    }

    public OpsMode() {
        this.initializeOpsMode();
    }

    public OperationMode getMode() {
        OperationMode mode = this.operationMode.get();
        if (mode != null) {
            return mode;
        }
        return OperationMode.DEVELOPMENT;
    }

    private void initializeOpsMode() {
        String mode = this.readInstanceState();
        if (mode == null && (mode = BootActivator.getInstance().getContext().getProperty(this.PROPERTY_KEY_OPS_MODE)) != null) {
            this.persistInstanceState(OperationMode.fromString(mode));
        }
        if (mode != null) {
            this.operationMode.compareAndSet(null, OperationMode.fromString(mode));
        }
    }

    public boolean isSet() {
        return this.operationMode.get() != null;
    }

    private void persistInstanceState(OperationMode mode) {
        if (mode == null) {
            return;
        }
        File instanceState = OpsMode.getInstanceStateFile();
        if (instanceState == null || instanceState.exists()) {
            return;
        }
        instanceState.getParentFile().mkdirs();
        FileOutputStream stream = null;
        try {
            try {
                stream = FileUtils.openOutputStream((File)instanceState);
                switch (mode) {
                    case PRODUCTION: {
                        stream.write(112);
                        break;
                    }
                    default: {
                        stream.write(100);
                        break;
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Error saving operation mode. {}", (Object)e.getMessage());
                IOUtils.closeQuietly((OutputStream)stream);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }

    /*
     * Loose catch block
     */
    private String readInstanceState() {
        FileInputStream stream;
        block15: {
            block16: {
                File instanceState = OpsMode.getInstanceStateFile();
                if (instanceState == null || !instanceState.canRead()) {
                    return null;
                }
                stream = null;
                stream = new FileInputStream(instanceState);
                int data = stream.read();
                if (data != 112) break block15;
                if (stream == null) break block16;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return PRODUCTION;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return DEVELOPMENT;
        catch (IOException iOException) {
            block17: {
                try {
                    if (stream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public void setMode(OperationMode mode) {
        if (mode != null) {
            this.persistInstanceState(mode);
        }
    }
}

