/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.admin;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperNodeInfo;

public class NodeDescriptor
implements INodeDescriptor {
    private final String nodeId;
    private ZooKeeperNodeInfo info;
    private final boolean approved;

    public NodeDescriptor(String nodeId, boolean approved) {
        this.nodeId = nodeId;
        this.approved = approved;
    }

    private ZooKeeperNodeInfo ensureInfo() {
        if (this.info != null) {
            return this.info;
        }
        this.info = ZooKeeperNodeInfo.load(this.nodeId, this.approved);
        if (this.info == null) {
            throw new IllegalStateException("node info not available!");
        }
        return this.info;
    }

    @Override
    public String getId() {
        return this.nodeId;
    }

    @Override
    public String getLocation() {
        String location = this.ensureInfo().getLocation();
        if (location == null) {
            return "unknown";
        }
        return location;
    }

    @Override
    public String getName() {
        String name = this.ensureInfo().getName();
        if (name == null) {
            return "";
        }
        return name;
    }

    @Override
    public Set<String> getTags() {
        Set<String> roles = this.ensureInfo().getTags();
        if (roles == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(roles);
    }

    @Override
    public boolean isApproved() {
        return this.approved;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_FIELD_NAMES_STYLE).append("id", (Object)this.nodeId).append("approved", this.approved).append("info", (Object)this.info).toString();
    }
}

