/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.console;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.common.console.Command;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class SetNodeTagsCmd
extends Command {
    @Argument(index=0, metaVar="NODEID", usage="specify the node id", required=true)
    String nodeId;
    @Option(name="-t", aliases={"--tag"}, usage="specify a tag")
    List<String> tags;

    public SetNodeTagsCmd() {
        super("<nodeId> [-t <tag> [-t <tag>]] - set tags for a node");
    }

    protected void doExecute() throws Exception {
        ICloudManager cloudManager = (ICloudManager)CloudActivator.getInstance().getService(ICloudManager.class);
        HashSet<String> consolidatedTags = this.tags != null ? new HashSet<String>(this.tags) : null;
        IStatus status = cloudManager.getNodeConfigurer(this.nodeId).setTags(consolidatedTags);
        if (status.isOK()) {
            if (consolidatedTags != null) {
                this.printf("Tags of node %s updated to %s!", new Object[]{this.nodeId, StringUtils.join(consolidatedTags, (char)',')});
            } else {
                this.printf("Tags of node %s cleared!", new Object[]{this.nodeId});
            }
        } else {
            this.printf(status.getMessage(), new Object[0]);
        }
    }
}

