/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.state;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.internal.state.NodeStateInfoImpl;
import org.eclipse.gyrex.cloud.internal.zk.GateDownException;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperBasedService;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.services.state.INodeState;
import org.eclipse.gyrex.cloud.services.state.query.INodeStateInfo;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperNodeStatePublisher
extends ZooKeeperBasedService {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperNodeStatePublisher.class);
    private final String myNodeId;

    static Properties getStateData(ServiceReference<INodeState> reference) {
        SortedProperties props = new SortedProperties();
        String[] stringArray = reference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            String key = stringArray[n2];
            if (!key.equals("objectClass") && !key.startsWith("service.") && (value = reference.getProperty(key)) != null) {
                props.setProperty(key, String.valueOf(value));
            }
            ++n2;
        }
        return props;
    }

    public ZooKeeperNodeStatePublisher(String myNodeId) {
        this.myNodeId = myNodeId;
    }

    public List<? extends INodeStateInfo> findByNodeId(String nodeId) {
        if (!IdHelper.isValidId((String)nodeId)) {
            throw new IllegalArgumentException("Invalid Node ID");
        }
        try {
            return this.execute(new ReadAllForNodeId(nodeId));
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
        }
        catch (Exception e) {
            if (e instanceof KeeperException.ConnectionLossException || e instanceof GateDownException) {
                LOG.debug("Unable to read state for node '{}'. {}", new Object[]{nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            LOG.error("Unable to read state for node '{}'. {}", new Object[]{nodeId, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return Collections.emptyList();
    }

    public List<? extends INodeStateInfo> findByServicePid(String servicePid) {
        if (!IdHelper.isValidId((String)servicePid)) {
            throw new IllegalArgumentException("Invalid Service PID");
        }
        try {
            return this.execute(new ReadAllForServicePid(servicePid));
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
        }
        catch (Exception e) {
            if (e instanceof KeeperException.ConnectionLossException || e instanceof GateDownException) {
                LOG.debug("Unable to read state for service pid '{}'. {}", new Object[]{servicePid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            LOG.error("Unable to read state for service pid '{}'. {}", new Object[]{servicePid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return Collections.emptyList();
    }

    @Override
    protected String getToStringDetails() {
        return this.myNodeId;
    }

    public void publish(final String pid, final ServiceReference<INodeState> reference) {
        if (!IdHelper.isValidId((String)pid)) {
            throw new IllegalArgumentException("Invalid PID");
        }
        try {
            this.execute(new ZooKeeperBasedService.ZooKeeperGateCallable<Boolean>(){

                @Override
                protected Boolean call(ZooKeeperGate keeper) throws Exception {
                    Properties props = ZooKeeperNodeStatePublisher.getStateData((ServiceReference<INodeState>)reference);
                    if (props.isEmpty()) {
                        return Boolean.FALSE;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    props.store((OutputStream)out, null);
                    byte[] data = out.toByteArray();
                    keeper.writeRecord(IZooKeeperLayout.PATH_NODES_STATE_BY_NODE_ID.append(ZooKeeperNodeStatePublisher.this.myNodeId).append(pid), CreateMode.EPHEMERAL, data);
                    keeper.writeRecord(IZooKeeperLayout.PATH_NODES_STATE_BY_SERVICE_PID.append(pid).append(ZooKeeperNodeStatePublisher.this.myNodeId), CreateMode.EPHEMERAL, data);
                    return Boolean.TRUE;
                }
            });
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
        }
        catch (Exception e) {
            if (e instanceof KeeperException.ConnectionLossException || e instanceof GateDownException) {
                LOG.debug("Unable to publish node state '{}'. {}", new Object[]{pid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            LOG.error("Unable to publish node state '{}'. {}", new Object[]{pid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void remove(final String pid) {
        try {
            this.execute(new ZooKeeperBasedService.ZooKeeperGateCallable<Boolean>(){

                @Override
                protected Boolean call(ZooKeeperGate keeper) throws Exception {
                    keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_NODE_ID.append(ZooKeeperNodeStatePublisher.this.myNodeId).append(pid));
                    keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_SERVICE_PID.append(pid).append(ZooKeeperNodeStatePublisher.this.myNodeId));
                    try {
                        keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_NODE_ID.append(ZooKeeperNodeStatePublisher.this.myNodeId));
                        keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_NODE_ID);
                    }
                    catch (KeeperException.NotEmptyException notEmptyException) {}
                    try {
                        keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_SERVICE_PID.append(pid));
                        keeper.deletePath(IZooKeeperLayout.PATH_NODES_STATE_BY_SERVICE_PID);
                    }
                    catch (KeeperException.NotEmptyException notEmptyException) {}
                    return Boolean.TRUE;
                }
            });
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
        }
        catch (Exception e) {
            if (e instanceof KeeperException.ConnectionLossException || e instanceof GateDownException) {
                LOG.debug("Unable to remove node state '{}'. {}", new Object[]{pid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
            LOG.error("Unable to remove node state '{}'. {}", new Object[]{pid, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    public void shutdown() {
        this.close();
    }

    private static final class ReadAllForNodeId
    extends ReadFromPath {
        private final String nodeId;

        private ReadAllForNodeId(String nodeId) {
            super(IZooKeeperLayout.PATH_NODES_STATE_BY_NODE_ID.append(nodeId));
            this.nodeId = nodeId;
        }

        @Override
        protected NodeStateInfoImpl createInfo(Map<String, String> data, String childName) {
            return new NodeStateInfoImpl(childName, this.nodeId, data);
        }
    }

    private static final class ReadAllForServicePid
    extends ReadFromPath {
        private final String servicePid;

        private ReadAllForServicePid(String servicePid) {
            super(IZooKeeperLayout.PATH_NODES_STATE_BY_SERVICE_PID.append(servicePid));
            this.servicePid = servicePid;
        }

        @Override
        protected NodeStateInfoImpl createInfo(Map<String, String> data, String childName) {
            return new NodeStateInfoImpl(this.servicePid, childName, data);
        }
    }

    private static abstract class ReadFromPath
    extends ZooKeeperBasedService.ZooKeeperGateCallable<List<? extends INodeStateInfo>> {
        private final IPath path;

        public ReadFromPath(IPath path) {
            this.path = path;
        }

        @Override
        protected List<? extends INodeStateInfo> call(ZooKeeperGate keeper) throws Exception {
            List<String> childNames;
            try {
                childNames = keeper.readChildrenNames(this.path, null);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                return Collections.emptyList();
            }
            if (childNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<NodeStateInfoImpl> infos = new ArrayList<NodeStateInfoImpl>(childNames.size());
            for (String childName : childNames) {
                byte[] data;
                try {
                    data = keeper.readRecord(this.path.append(childName), null);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    continue;
                }
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(data));
                Map<Object, Object> map = Collections.unmodifiableMap(props);
                infos.add(this.createInfo(map, childName));
            }
            return infos;
        }

        protected abstract NodeStateInfoImpl createInfo(Map<String, String> var1, String var2);
    }

    private static final class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.keySet());
        }

        @Override
        public Set<Object> keySet() {
            return new TreeSet<Object>(super.keySet());
        }
    }
}

