/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.GateDownException;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateConfig;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateListener;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperHelper;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperGate {
    private static final CopyOnWriteArrayList<ZooKeeperGateListener> gateListeners = new CopyOnWriteArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperGate.class);
    private static final AtomicReference<ZooKeeperGate> instanceRef = new AtomicReference();
    private final DebuggableZooKeeper zooKeeper;
    private final ZooKeeperGateListener reconnectMonitor;
    private final Job recoveryTimeoutJob = new Job("ZooKeeper Gate Recovery"){

        protected IStatus run(IProgressMonitor monitor) {
            if (!ZooKeeperGate.this.zooKeeper.getState().isAlive()) {
                return Status.CANCEL_STATUS;
            }
            if (ZooKeeperGate.this.keeperStateRef.compareAndSet(Watcher.Event.KeeperState.Disconnected, Watcher.Event.KeeperState.Expired)) {
                ZooKeeperGate.this.shutdown(true);
            }
            return Status.OK_STATUS;
        }
    };
    private final Watcher gateWatcher;
    private final AtomicReference<Watcher.Event.KeeperState> keeperStateRef;
    private final String connectString;
    private final int sessionTimeout;

    public static void addConnectionMonitor(ZooKeeperGateListener listener) {
        if (listener == null) {
            return;
        }
        gateListeners.addIfAbsent(listener);
    }

    private static String gateDownError(ZooKeeperGate gate) {
        try {
            return String.format("ZooKeeper Gate is DOWN. (%s)", String.valueOf(gate));
        }
        catch (Throwable e) {
            if (e instanceof VirtualMachineError || e instanceof LinkageError) {
                throw (Error)e;
            }
            return String.format("ZooKeeper Gate is DOWN. (%s)", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public static ZooKeeperGate get() throws GateDownException {
        ZooKeeperGate gate = instanceRef.get();
        if (gate == null) {
            throw new GateDownException(ZooKeeperGate.gateDownError(null));
        }
        return gate;
    }

    static ZooKeeperGate getAndSet(ZooKeeperGate gate) {
        ZooKeeperGate old = instanceRef.getAndSet(gate);
        if (CloudDebug.zooKeeperGateLifecycle) {
            LOG.debug("Set new ZooKeeper Gate instance. {} (old {})", new Object[]{gate, old});
        }
        return old;
    }

    static boolean isCurrentGate(ZooKeeperGate gate) {
        return gate != null && gate == instanceRef.get();
    }

    public static void removeConnectionMonitor(ZooKeeperGateListener connectionMonitor) {
        if (connectionMonitor == null) {
            return;
        }
        gateListeners.remove(connectionMonitor);
    }

    ZooKeeperGate(ZooKeeperGateConfig config, ZooKeeperGateListener reconnectMonitor) throws IOException {
        this.recoveryTimeoutJob.setSystem(true);
        this.recoveryTimeoutJob.setPriority(20);
        this.gateWatcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() != Watcher.Event.EventType.None) {
                    if (CloudDebug.zooKeeperGateLifecycle) {
                        LOG.trace("Ignoring event ({}).", (Object)event);
                    }
                    return;
                }
                ZooKeeperGate gate = ZooKeeperGate.this;
                if (!ZooKeeperGate.isCurrentGate(gate)) {
                    if (CloudDebug.zooKeeperGateLifecycle) {
                        LOG.debug("Ignored connection event for inactive gate: {}, {}", (Object)gate, (Object)event);
                    }
                    return;
                }
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Connection event: {}", (Object)event);
                }
                switch (event.getState()) {
                    case SyncConnected: {
                        LOG.info("ZooKeeper Gate is now UP. Session 0x{} established with {} (using timeout {}ms).", new Object[]{Long.toHexString(ZooKeeperGate.this.zooKeeper.getSessionId()), ZooKeeperGate.this.zooKeeper.testableRemoteSocketAddress(), ZooKeeperGate.this.zooKeeper.getSessionTimeout()});
                        Watcher.Event.KeeperState oldState = ZooKeeperGate.this.keeperStateRef.getAndSet(Watcher.Event.KeeperState.SyncConnected);
                        ZooKeeperGate.this.recoveryTimeoutJob.cancel();
                        if (oldState != Watcher.Event.KeeperState.SyncConnected) {
                            ZooKeeperGate.this.notifyGateUp();
                            break;
                        }
                        if (!CloudDebug.zooKeeperGateLifecycle) break;
                        LOG.debug("Old state == new state, not sending any events.");
                        break;
                    }
                    case Disconnected: {
                        LOG.info("ZooKeeper Gate is now RECOVERING. Connection lost.");
                        Watcher.Event.KeeperState oldState = ZooKeeperGate.this.keeperStateRef.getAndSet(Watcher.Event.KeeperState.Disconnected);
                        ZooKeeperGate.this.recoveryTimeoutJob.schedule(Math.max(500L, (long)ZooKeeperGate.this.zooKeeper.getSessionTimeout() + 500L));
                        if (oldState != Watcher.Event.KeeperState.Disconnected) {
                            ZooKeeperGate.this.notifyGateRecovering();
                            break;
                        }
                        if (!CloudDebug.zooKeeperGateLifecycle) break;
                        LOG.debug("Old state == new state, not sending any events.");
                        break;
                    }
                    case Expired: {
                        LOG.info("ZooKeeper Gate is now DOWN. Session expired.");
                        Watcher.Event.KeeperState oldState = ZooKeeperGate.this.keeperStateRef.getAndSet(Watcher.Event.KeeperState.Expired);
                        ZooKeeperGate.this.recoveryTimeoutJob.cancel();
                        ZooKeeperGate.this.shutdown(oldState != Watcher.Event.KeeperState.Expired);
                        break;
                    }
                    default: {
                        LOG.warn("Received event {} from ZooKeeper. Gate is not intervening. ({})", (Object)event.getState(), (Object)ZooKeeperGate.this.zooKeeper);
                    }
                }
            }
        };
        this.keeperStateRef = new AtomicReference();
        this.reconnectMonitor = reconnectMonitor;
        this.connectString = config.getConnectString();
        this.sessionTimeout = config.getSessionTimeout();
        this.zooKeeper = new DebuggableZooKeeper(this.connectString, this.sessionTimeout, this.gateWatcher);
        if (CloudDebug.zooKeeperGateLifecycle) {
            LOG.debug("New ZooKeeper Gate instance. {}", (Object)this, (Object)new Exception("ZooKeeper Gate Constructor Call Stack"));
        }
    }

    private IPath create(IPath path, CreateMode createMode, byte[] data) throws InterruptedException, KeeperException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        ZooKeeperHelper.createParents(this.getZooKeeper(), path);
        return new Path(this.getZooKeeper().create(path.toString(), data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode));
    }

    public IPath createPath(IPath path, CreateMode createMode) throws KeeperException, InterruptedException, IOException {
        return this.create(path, createMode, null);
    }

    public IPath createPath(IPath path, CreateMode createMode, byte[] recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        return this.create(path, createMode, recordData);
    }

    public IPath createPath(IPath path, CreateMode createMode, String recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        try {
            return this.createPath(path, createMode, recordData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public void deletePath(IPath path) throws KeeperException, InterruptedException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        try {
            List children = this.getZooKeeper().getChildren(path.toString(), false);
            for (String child : children) {
                this.deletePath(path.append(child));
            }
            this.getZooKeeper().delete(path.toString(), -1);
        }
        catch (KeeperException e) {
            if (e.code() != KeeperException.Code.NONODE) {
                throw e;
            }
            return;
        }
    }

    public void deletePath(IPath path, int version) throws InterruptedException, IOException, KeeperException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        Stat stat = new Stat();
        List children = this.getZooKeeper().getChildren(path.toString(), false, stat);
        if (version != -1 && stat.getVersion() != version) {
            throw new KeeperException.BadVersionException(path.toString());
        }
        for (String child : children) {
            this.deletePath(path.append(child));
        }
        this.getZooKeeper().delete(path.toString(), version);
    }

    public boolean exists(IPath path) throws InterruptedException, KeeperException {
        return this.exists(path, null);
    }

    public boolean exists(IPath path, ZooKeeperMonitor monitor) throws InterruptedException, KeeperException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.getZooKeeper().exists(path.toString(), (Watcher)monitor) != null;
    }

    public String getConnectedServerInfo() {
        SocketAddress socketAddress = this.zooKeeper.testableRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return String.format("%s:%d", ((InetSocketAddress)socketAddress).getHostName(), ((InetSocketAddress)socketAddress).getPort());
        }
        if (socketAddress != null) {
            return socketAddress.toString();
        }
        return null;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public long getSessionId() {
        return this.getZooKeeper().getSessionId();
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    final ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    private void handleBrokenListener(ZooKeeperGateListener listener, Throwable t) {
        LOG.error("Removing bogous connection listener {} due to exception ({}).", new Object[]{listener, ExceptionUtils.getMessage((Throwable)t), t});
        gateListeners.remove(listener);
    }

    void notifyGateDown() {
        for (ZooKeeperGateListener listener : gateListeners) {
            try {
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Sending gate down event to listener ({}).", (Object)listener);
                }
                listener.gateDown(this);
            }
            catch (RuntimeException e) {
                this.handleBrokenListener(listener, e);
            }
            catch (AssertionError e) {
                this.handleBrokenListener(listener, (Throwable)((Object)e));
            }
            catch (LinkageError e) {
                this.handleBrokenListener(listener, e);
            }
        }
        if (this.reconnectMonitor != null) {
            this.reconnectMonitor.gateDown(this);
        }
    }

    void notifyGateRecovering() {
        for (ZooKeeperGateListener listener : gateListeners) {
            try {
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Sending gate recovering event to listener ({}).", (Object)listener);
                }
                listener.gateRecovering(this);
            }
            catch (RuntimeException e) {
                this.handleBrokenListener(listener, e);
            }
            catch (AssertionError e) {
                this.handleBrokenListener(listener, (Throwable)((Object)e));
            }
            catch (LinkageError e) {
                this.handleBrokenListener(listener, e);
            }
        }
        if (this.reconnectMonitor != null) {
            this.reconnectMonitor.gateRecovering(this);
        }
    }

    void notifyGateUp() {
        if (this.reconnectMonitor != null) {
            this.reconnectMonitor.gateUp(this);
        }
        for (ZooKeeperGateListener listener : gateListeners) {
            try {
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Sending gate up event to listener ({}).", (Object)listener);
                }
                listener.gateUp(this);
            }
            catch (RuntimeException e) {
                this.handleBrokenListener(listener, e);
            }
            catch (AssertionError e) {
                this.handleBrokenListener(listener, (Throwable)((Object)e));
            }
            catch (LinkageError e) {
                this.handleBrokenListener(listener, e);
            }
        }
    }

    public List<String> readChildrenNames(IPath path, Stat stat) throws InterruptedException, KeeperException {
        return this.readChildrenNames(path, null, stat);
    }

    public List<String> readChildrenNames(IPath path, ZooKeeperMonitor watch, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.getZooKeeper().getChildren(path.toString(), (Watcher)watch, stat);
    }

    public byte[] readRecord(IPath path, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException, IOException {
        return this.readRecord(path, (ZooKeeperMonitor)null, stat);
    }

    public String readRecord(IPath path, String defaultValue, Stat stat) throws KeeperException, InterruptedException, IOException {
        try {
            byte[] data = this.readRecord(path, stat);
            if (data == null) {
                return defaultValue;
            }
            return new String(data, "UTF-8");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return defaultValue;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public byte[] readRecord(IPath path, ZooKeeperMonitor watch, Stat stat) throws KeeperException.NoNodeException, KeeperException, InterruptedException, IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.getZooKeeper().getData(path.toString(), (Watcher)watch, stat);
    }

    private Stat setData(IPath path, CreateMode createMode, byte[] data, int version) throws InterruptedException, KeeperException, IOException {
        block4: {
            if (path == null) {
                throw new IllegalArgumentException("path must not be null");
            }
            if (createMode != null && !this.exists(path)) {
                try {
                    this.create(path, createMode, data);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NODEEXISTS) break block4;
                    throw e;
                }
            }
        }
        return this.getZooKeeper().setData(path.toString(), data, version);
    }

    void shutdown(boolean notify) {
        block5: {
            if (CloudDebug.zooKeeperGateLifecycle) {
                LOG.debug("Shutdown of ZooKeeper Gate. {}", (Object)this, (Object)new Exception("ZooKeeper Gate Shutdown Call Stack"));
            }
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                if (!CloudDebug.zooKeeperGateLifecycle) break block5;
                LOG.debug("Ignored exception during shutdown: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (notify) {
            this.notifyGateDown();
        }
    }

    public void testShutdown() throws InterruptedException {
        this.shutdown(true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ZooKeeperGate ");
        if (ZooKeeperGate.isCurrentGate(this)) {
            builder.append("CURRENT ");
        }
        builder.append("[").append((Object)this.zooKeeper).append("]");
        return builder.toString();
    }

    public Stat writeRecord(IPath path, byte[] recordData, int version) throws InterruptedException, KeeperException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        return this.setData(path, null, recordData, version);
    }

    public Stat writeRecord(IPath path, CreateMode createMode, byte[] recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        return this.setData(path, createMode, recordData, -1);
    }

    public Stat writeRecord(IPath path, CreateMode createMode, String recordData) throws KeeperException, InterruptedException, IOException {
        if (recordData == null) {
            throw new IllegalArgumentException("recordData must not be null");
        }
        if (createMode == null) {
            throw new IllegalArgumentException("createMode must not be null");
        }
        try {
            return this.writeRecord(path, createMode, recordData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    public Stat writeRecord(IPath path, String recordData, int version) throws InterruptedException, KeeperException, IOException {
        try {
            return this.writeRecord(path, recordData.getBytes("UTF-8"), version);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM does not support UTF-8.", e);
        }
    }

    static final class DebuggableZooKeeper
    extends ZooKeeper {
        public DebuggableZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        public DebuggableZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd) throws IOException {
            super(connectString, sessionTimeout, watcher, sessionId, sessionPasswd);
        }

        protected SocketAddress testableRemoteSocketAddress() {
            return super.testableRemoteSocketAddress();
        }

        protected boolean testableWaitForShutdown(int wait) throws InterruptedException {
            return super.testableWaitForShutdown(wait);
        }
    }
}

