/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.zookeeper.CreateMode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.monitoring.diagnostics.IStatusConstants;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperPinger
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperPinger.class);
    private static final String STATUS_PID = "org.eclipse.gyrex.cloud.status.zookeeper.connection";
    private static final Callable<IStatus> checkConnection = new Callable<IStatus>(){

        @Override
        public IStatus call() throws Exception {
            ZooKeeperGate zk = ZooKeeperGate.get();
            IPath pingPath = zk.createPath(IZooKeeperLayout.PATH_GYREX_ROOT.append("ping"), CreateMode.EPHEMERAL_SEQUENTIAL, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(System.currentTimeMillis()));
            zk.deletePath(pingPath);
            return null;
        }
    };
    private ServiceRegistration serviceRegistration;

    @Override
    public void run() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            try {
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("Checking ZooKeeper connection...");
                }
                executor.submit(checkConnection).get(30L, TimeUnit.SECONDS);
                if (CloudDebug.zooKeeperGateLifecycle) {
                    LOG.debug("ZooKeeper connection OK");
                }
                this.setStatus(null);
            }
            catch (Exception e) {
                LOG.error("The ZooKeeper connection is in trouble. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
                this.setStatus((IStatus)new Status(4, "org.eclipse.gyrex.cloud", String.format("Unable to ping ZooKeeper. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e));
                executor.shutdownNow();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private synchronized void setStatus(IStatus status) {
        try {
            if (this.serviceRegistration != null) {
                this.serviceRegistration.unregister();
                this.serviceRegistration = null;
            }
            if (status != null && !status.isOK()) {
                this.serviceRegistration = CloudActivator.getInstance().getServiceHelper().registerService(IStatusConstants.SERVICE_NAME, (Object)status, "Eclipse Gyrex", "ZooKeeper Connection Status", STATUS_PID, null);
            }
        }
        catch (IllegalStateException e) {
            LOG.warn("Unable to update ZooKeeper connection status. {}", (Object)e.getMessage());
        }
    }
}

