/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.eclipse.gyrex.context.internal.provider.ProviderRegistration;
import org.eclipse.gyrex.context.internal.provider.TypeRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GyrexContextObject
implements IContextDisposalListener,
ProviderRegistration.ProviderRegistrationReference,
TypeRegistration.TypeRegistrationReference {
    private static final Logger LOG = LoggerFactory.getLogger(GyrexContextObject.class);
    private final Lock objectCreationLock = new ReentrantLock();
    private final Class<?> type;
    private GyrexContextImpl context;
    private volatile boolean isComputed;
    private volatile Object computedObject;
    private volatile ProviderRegistration computedObjectProvider;

    public GyrexContextObject(GyrexContextImpl runtimeContext, Class<?> type) {
        this.context = runtimeContext;
        this.type = type;
    }

    private void clearComputedObject() {
        ProviderRegistration provider;
        Object object;
        if (!this.isComputed) {
            return;
        }
        this.objectCreationLock.tryLock();
        try {
            if (!this.isComputed) {
                return;
            }
            this.isComputed = false;
            object = this.computedObject;
            provider = this.computedObjectProvider;
            this.computedObject = null;
            this.computedObjectProvider = null;
        }
        finally {
            this.objectCreationLock.unlock();
        }
        if (ContextDebug.objectLifecycle) {
            LOG.debug("Flushing computed object {}", (Object)this);
        }
        try {
            if (provider != null) {
                provider.getProvider().ungetObject(object, this.context.getHandle());
            }
        }
        finally {
            if (provider != null) {
                provider.removeReference(this);
            }
            if (this.context != null) {
                this.context.removeDisposable(this);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Object compute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void contextDisposed(IRuntimeContext runtimeContext) {
        if (ContextDebug.objectLifecycle) {
            LOG.debug("Context {} disposed, disposing {}", (Object)runtimeContext, (Object)this);
        }
        this.clearComputedObject();
        this.context = null;
    }

    public void dump(int ident, StrBuilder dump) {
        dump.appendPadding(ident, ' ').appendln(this.computedObject);
    }

    @Override
    public void flushReference(ProviderRegistration provider) {
        this.clearComputedObject();
    }

    @Override
    public void flushReference(TypeRegistration typeRegsitration) {
        this.clearComputedObject();
    }

    public String toString() {
        GyrexContextImpl context = this.context;
        if (context == null) {
            return "GyrexContextObject [DISPOSED]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("GyrexContextObject [context=").append((Object)context).append(", type=").append(this.type).append("]");
        return builder.toString();
    }
}

