/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.http.internal.BundleFinder;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.StatusMonitor;
import org.eclipse.gyrex.http.jetty.internal.admin.JettyManagerImpl;
import org.eclipse.jetty.util.IO;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HttpJettyActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.http.jetty";
    private static final AtomicReference<HttpJettyActivator> instanceRef = new AtomicReference();
    private volatile JettyManagerImpl jettyManager;
    private IServiceProxy<INodeEnvironment> nodeEnvironmentService;
    private volatile StatusMonitor statusMonitor;

    public static HttpJettyActivator getInstance() throws IllegalStateException {
        HttpJettyActivator httpJettyActivator = instanceRef.get();
        if (httpJettyActivator == null) {
            throw new IllegalStateException("Bundle 'org.eclipse.gyrex.http.jetty' is inactive.");
        }
        return httpJettyActivator;
    }

    public static IStatus getPlatformStatus() {
        try {
            StatusMonitor monitor = HttpJettyActivator.getInstance().statusMonitor;
            if (monitor != null) {
                return monitor.getOverallStatus();
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return new Status(4, SYMBOLIC_NAME, "Jetty Integration is not active.");
    }

    public static byte[] readBundleResource(String bundleResource) {
        URL eclipseIconUrl = HttpJettyActivator.getInstance().getBundle().getEntry(bundleResource);
        if (eclipseIconUrl == null) {
            throw new IllegalStateException("Bundle resource not found: " + bundleResource);
        }
        InputStream in = null;
        try {
            in = eclipseIconUrl.openStream();
            byte[] byArray = IO.readBytes((InputStream)in);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)"Error reading resource {0}: {1}", (Object)bundleResource, (Object)e.getMessage()));
        }
        finally {
            IO.close((InputStream)in);
        }
    }

    public HttpJettyActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        this.statusMonitor = new StatusMonitor(context);
        this.statusMonitor.open();
        this.jettyManager = new JettyManagerImpl();
        this.getServiceHelper().registerService(IJettyManager.class.getName(), (Object)this.jettyManager, "Eclipse Gyrex", "Jetty Engine Manager", null, null);
        this.nodeEnvironmentService = this.getServiceHelper().trackService(INodeEnvironment.class);
    }

    protected void doStop(BundleContext context) throws Exception {
        instanceRef.set(null);
        this.jettyManager = null;
        this.statusMonitor.close();
        this.statusMonitor = null;
    }

    public Bundle getCallingBundle() {
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        return new BundleFinder(bundle).getCallingBundle();
    }

    protected Class getDebugOptions() {
        return JettyDebug.class;
    }

    public IJettyManager getJettyManager() {
        JettyManagerImpl manager = this.jettyManager;
        if (manager == null) {
            throw this.createBundleInactiveException();
        }
        return manager;
    }

    public INodeEnvironment getNodeEnvironment() {
        IServiceProxy<INodeEnvironment> proxy = this.nodeEnvironmentService;
        if (proxy == null) {
            throw this.createBundleInactiveException();
        }
        return (INodeEnvironment)proxy.getService();
    }
}

