/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.handlers.ErrorPage;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;

public class DefaultErrorHandler
extends ErrorHandler {
    private static final String NEWLINE = "\n";
    private static final boolean debugMode = Platform.inDebugMode();
    private static final Set<String> handledMethods;

    static {
        HashSet<String> methods = new HashSet<String>();
        methods.add("GET");
        methods.add("POST");
        methods.add("PUT");
        methods.add("HEAD");
        methods.add("DELETE");
        handledMethods = Collections.unmodifiableSet(methods);
    }

    static String getServerName(HttpServletRequest request) {
        String serverName = null;
        AbstractHttpConnection httpConnection = AbstractHttpConnection.getCurrentConnection();
        if (httpConnection != null) {
            serverName = httpConnection.getConnector().getHost();
        }
        if (serverName == null || serverName.equals("0.0.0.0")) {
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                serverName = request.getServerName();
            }
        }
        return serverName;
    }

    public DefaultErrorHandler() {
        this.setShowStacks(Platform.inDevelopmentMode());
    }

    private boolean acceptsHtml(HttpServletRequest request) {
        Enumeration acceptHeaders = request.getHeaders("Accept");
        if (acceptHeaders != null) {
            while (acceptHeaders.hasMoreElements()) {
                String accept = (String)acceptHeaders.nextElement();
                if (accept.indexOf("text/html") <= -1 && accept.indexOf("application/xhtml") <= -1 && accept.indexOf("*/*") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private void generateErrorPagePlain(HttpServletRequest request, HttpServletResponse response, int code, String internalMessage, String officialMessage, String serverName) throws IOException {
        response.setContentType("text/html;charset=ISO-8859-1");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(4096);
        this.writeErrorPagePlain(request, (Writer)writer, code, internalMessage, officialMessage, serverName);
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo((OutputStream)response.getOutputStream());
        writer.destroy();
    }

    private String getAdminServerURL(HttpServletRequest request) {
        return "http://".concat(request.getServerName()).concat(":3110/");
    }

    private AbstractHttpConnection getCurrentConnection() {
        AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
        if (connection == null) {
            throw new IllegalStateException("Called outside request thread! No connection available.");
        }
        return connection;
    }

    private Throwable getException(HttpServletRequest request) {
        return (Throwable)request.getAttribute("javax.servlet.error.exception");
    }

    private String getOverallStatusMessage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return "It looks like that this server is not configured properly.";
            }
            case 2: {
                return "It looks like that the platform configuration is not perfect.";
            }
        }
        return "The platform configuration looks okay. Some hints/notes are available, though.";
    }

    private String getStatusBullet(IStatus status) {
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                return " ! ";
            }
            case 2: {
                return " ? ";
            }
        }
        return " * ";
    }

    public void handle(String target, final Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AbstractHttpConnection connection = this.getCurrentConnection();
        connection.getRequest().setHandled(true);
        String method = request.getMethod();
        if (!handledMethods.contains(method)) {
            return;
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        int code = connection.getResponse().getStatus();
        String internalMessage = connection.getResponse().getReason();
        if (internalMessage == null && code == 500 && this.getException(request) != null) {
            internalMessage = this.getException(request).toString();
        }
        if (internalMessage != null) {
            try {
                internalMessage = URLDecoder.decode(internalMessage, "UTF-8");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        String officialMessage = HttpStatus.getMessage((int)code);
        if (!this.acceptsHtml(request)) {
            this.generateErrorPagePlain(request, response, code, internalMessage, officialMessage, DefaultErrorHandler.getServerName(request));
            return;
        }
        ErrorPage errorPage = new ErrorPage(){

            @Override
            protected void writeDebugInfo(HttpServletRequest request, Writer writer) throws IOException {
                super.writeDebugInfo((HttpServletRequest)baseRequest, writer);
                if (this.getCode() == 404) {
                    Handler[] handlers;
                    Object debugInfo = request.getAttribute(ApplicationHandler.ATTRIBUTE_DEBUG_INFO);
                    if (debugInfo != null) {
                        writer.write("<div class=\"dev_note\">");
                        writer.write("Resources known to last request handling application are:");
                        writer.write("<pre>");
                        writer.write(DefaultErrorHandler.NEWLINE);
                        1.writeEscaped(writer, debugInfo.toString());
                        writer.write("</pre>");
                        writer.write(DefaultErrorHandler.NEWLINE);
                        writer.write("</div>");
                    }
                    writer.write("<div class=\"dev_note\">");
                    Server server = DefaultErrorHandler.this.getServer();
                    Handler[] handlerArray = handlers = server == null ? null : server.getChildHandlersByClass(ApplicationHandler.class);
                    if (handlers != null && handlers.length > 0) {
                        writer.write("Applications known to this server are: <ul>");
                        writer.write(DefaultErrorHandler.NEWLINE);
                        int i = 0;
                        while (handlers != null && i < handlers.length) {
                            String[] urls;
                            writer.write("<li>");
                            ApplicationHandler appHandler = (ApplicationHandler)handlers[i];
                            1.writeEscaped(writer, appHandler.getApplicationId());
                            writer.write(" (");
                            1.writeEscaped(writer, appHandler.getApplicationRegistration().getProviderId());
                            writer.write(64);
                            1.writeEscaped(writer, appHandler.getApplicationRegistration().getContext().getContextPath());
                            writer.write(")");
                            if (appHandler.isRunning()) {
                                writer.write(" [running]");
                            } else {
                                if (appHandler.isFailed()) {
                                    writer.write(" [failed]");
                                }
                                if (appHandler.isStopped()) {
                                    writer.write(" [stopped]");
                                }
                            }
                            String[] stringArray = urls = appHandler.getUrls();
                            int n = urls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String url = stringArray[n2];
                                writer.write(String.format("<br><small> --&gt; <a href=\"%s\">%s</a></small>", url, url));
                                ++n2;
                            }
                            writer.write("</li>");
                            writer.write(DefaultErrorHandler.NEWLINE);
                            ++i;
                        }
                        writer.write("</ul>");
                        writer.write(DefaultErrorHandler.NEWLINE);
                    } else {
                        writer.write("No applications known to this server!");
                        writer.write(DefaultErrorHandler.NEWLINE);
                    }
                    writer.write("</div>");
                }
            }
        };
        errorPage.setCode(code);
        errorPage.setOfficialMessage(officialMessage);
        errorPage.setInternalMessage(internalMessage);
        errorPage.render(request, response);
    }

    private void writeErrorPagePlain(HttpServletRequest request, Writer writer, int code, String internalMessage, String officialMessage, String serverName) throws IOException {
        AbstractHttpConnection.getCurrentConnection().getResponse().setContentType("text/plain;charset=ISO-8859-1");
        writer.write("Error ");
        writer.write(Integer.toString(code));
        writer.write(" - ");
        this.writePlain(writer, officialMessage);
        writer.write(NEWLINE);
        if (debugMode) {
            Throwable exception;
            if (internalMessage != null) {
                writer.write(NEWLINE);
                this.writePlain(writer, internalMessage);
                writer.write(NEWLINE);
            }
            if ((exception = this.getException(request)) != null) {
                writer.write(NEWLINE);
                this.writeException(exception, writer);
                writer.write(NEWLINE);
            }
            writer.write(NEWLINE);
            IStatus platformStatus = HttpJettyActivator.getPlatformStatus();
            if (!platformStatus.isOK()) {
                writer.write(String.valueOf(this.getOverallStatusMessage(platformStatus)) + NEWLINE);
                writer.write("You might want to check the server configuration (" + this.getAdminServerURL(request) + ")." + NEWLINE);
                writer.write(NEWLINE);
                writer.write("Issues detected on ");
                writer.write(serverName);
                writer.write(":\n");
                this.writeStatusPlain(platformStatus, writer);
                writer.write(NEWLINE);
            } else {
                writer.write("A note to developers, this server seems to be configured properly.\nAt least, no issues were detected.\n");
            }
        } else {
            writer.write("If you think you've reached this page in error:\n  * Make sure the URL you're trying to reach is correct.\n</ul>\n\r\n");
        }
        writer.write(NEWLINE);
        writer.write(NEWLINE);
        writer.write("-- ");
        writer.write(NEWLINE);
        writer.write("Brought to you by Gyrex. Powered by Jetty and Equinox.");
        writer.write(NEWLINE);
    }

    private void writeEscaped(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        writer.write(63);
                        break;
                    }
                    writer.write(c);
                }
            }
            ++i;
        }
    }

    private void writeException(Throwable exception, Writer writer) {
        exception.printStackTrace(new PrintWriter(writer));
    }

    private void writePlain(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                writer.write(63);
            } else {
                writer.write(c);
            }
            ++i;
        }
    }

    private void writeStatusItemPlain(IStatus status, Writer writer, int identSize) throws IOException {
        if (status.isOK()) {
            return;
        }
        String ident = "";
        int i = 0;
        while (i < identSize) {
            ident = String.valueOf(ident) + " ";
            ++i;
        }
        writer.write(ident);
        writer.write(this.getStatusBullet(status));
        this.writeEscaped(writer, status.getMessage());
        writer.write(" (");
        this.writeEscaped(writer, status.getPlugin());
        writer.write(", code ");
        this.writeEscaped(writer, String.valueOf(status.getCode()));
        writer.write(")");
        Throwable statusException = status.getException();
        if (statusException != null) {
            writer.write(NEWLINE);
            writer.write(ident);
            writer.write("   caused by: ");
            writer.write(statusException.toString());
        }
        writer.write(NEWLINE);
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItemPlain(child, writer, identSize + 3);
                ++n2;
            }
        }
    }

    private void writeStatusPlain(IStatus status, Writer writer) throws IOException {
        if (status.isOK()) {
            return;
        }
        String statusMessage = status.getMessage();
        if (status.isMultiStatus() && (statusMessage == null || statusMessage.trim().length() == 0)) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.writeStatusItemPlain(child, writer, 0);
                ++n2;
            }
        } else {
            this.writeStatusItemPlain(status, writer, 0);
        }
    }
}

