/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.eclipse.gyrex.http.registry.internal.ExtensionPointTracker;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager
implements ExtensionPointTracker.Listener {
    private static final String RESOURCES_EXTENSION_POINT = "org.eclipse.gyrex.http.applications";
    private static final String PATH = "path";
    private static final String ALIAS = "alias";
    private static final String RESOURCE = "resource";
    private static final String APPLICATION_ID = "applicationId";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManager.class);
    private final ExtensionPointTracker tracker;
    private final List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private final ApplicationRegistryManager applicationRegistryManager;

    public ResourceManager(ApplicationRegistryManager httpRegistryManager, ServiceReference reference, IExtensionRegistry registry) {
        this.applicationRegistryManager = httpRegistryManager;
        this.tracker = new ExtensionPointTracker(registry, RESOURCES_EXTENSION_POINT, this);
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement resourceElement = elements[i];
            if (RESOURCE.equals(resourceElement.getName())) {
                String alias = resourceElement.getAttribute(ALIAS);
                if (alias == null) {
                    LOG.warn("Ignoring resource extension element contributed by {}. Does not contain an alias.", (Object)resourceElement.getContributor());
                } else {
                    String applicationId;
                    String path = resourceElement.getAttribute(PATH);
                    if (path == null) {
                        path = "";
                    }
                    if (path.charAt(path.length() - 1) == '/') {
                        path = path.substring(0, path.length() - 1);
                    }
                    if ((applicationId = resourceElement.getAttribute(APPLICATION_ID)) == null) {
                        LOG.warn("Ignoring resource extension element contributed by {}. Does not contain an application id.", (Object)resourceElement.getContributor());
                    } else {
                        if (applicationId.indexOf(46) == -1) {
                            applicationId = String.valueOf(resourceElement.getNamespaceIdentifier()) + "." + applicationId;
                        }
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to add resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                        }
                        if (this.applicationRegistryManager.addResourcesContribution(alias, path, applicationId, extension.getContributor())) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully added resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                            }
                            this.registered.add(resourceElement);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not add resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement resourceElement = elements[i];
            if (RESOURCE.equals(resourceElement.getName())) {
                String alias = resourceElement.getAttribute(ALIAS);
                if (alias == null) {
                    LOG.warn("Ignoring resource extension element contributed by {}. Does not contain an alias.", (Object)resourceElement.getContributor());
                } else {
                    String applicationId = resourceElement.getAttribute(APPLICATION_ID);
                    if (applicationId == null) {
                        LOG.warn("Ignoring resource extension element contributed by {}. Does not contain an application id.", (Object)resourceElement.getContributor());
                    } else {
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to remove resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                        }
                        if (this.registered.remove(resourceElement)) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully removed resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                            }
                            this.applicationRegistryManager.removeContribution(alias, applicationId);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not remove resource {} to application {} (contributed by {}).", new Object[]{alias, applicationId, resourceElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }
}

