/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.tests.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistry;
import org.eclipse.gyrex.http.tests.internal.Activator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ApplicationRegistryTests {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testProviderRegistration() {
        BundleContext context = Activator.getBundleContext();
        ApplicationProviderRegistry registry = new ApplicationProviderRegistry(context);
        TestAppProvider appProvider = new TestAppProvider();
        try {
            registry.open();
            if (registry.getProviderRegistration(appProvider.getId()) != null) {
                Assert.fail((String)"there is already a provider registered; that should not happen");
            }
            ServiceRegistration serviceRegistration = context.registerService(ApplicationProvider.class.getName(), (Object)appProvider, null);
            ApplicationProviderRegistration providerRegistration = registry.getProviderRegistration(appProvider.getId());
            Assert.assertNotNull((String)"provider not registered with manager", (Object)providerRegistration);
            serviceRegistration.unregister();
            providerRegistration = registry.getProviderRegistration(appProvider.getId());
            Assert.assertNull((String)"provider should be unregistered at this point", (Object)providerRegistration);
        }
        finally {
            registry.close();
        }
    }

    static class TestApp
    extends Application {
        TestApp(String id, IRuntimeContext context) {
            super(id, context);
        }
    }

    static class TestAppProvider
    extends ApplicationProvider {
        TestAppProvider() {
            super(TestAppProvider.class.getName());
        }

        public Application createApplication(String applicationId, IRuntimeContext context) throws CoreException {
            return new TestApp(applicationId, context);
        }
    }
}

