/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.manager.JobHistoryItemImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHistoryImpl
implements IJobHistory {
    private static final String KEY_RESULT_SEVERITY = "resultSeverity";
    private static final String KEY_RESULT_MESSAGE = "resultMessage";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_QUEUED_TRIGGER = "queuedTrigger";
    private static final String KEY_CANCELLED_TRIGGER = "canceledTrigger";
    private static final int MAX_HISTORY_SIZE = 120;
    private static final Logger LOG = LoggerFactory.getLogger(JobHistoryImpl.class);
    private final String jobId;
    private final IPath contextPath;
    private SortedSet<IJobHistoryEntry> entries;

    private static IStatus convertStatus(IStatus status) {
        return new Status(status.getSeverity(), "org.eclipse.gyrex.jobs", JobHistoryImpl.getFormattedMessage(status, 0));
    }

    private static IStatus deserializeStatus(Preferences node) {
        return new Status(node.getInt(KEY_RESULT_SEVERITY, 8), "org.eclipse.gyrex.jobs", node.get(KEY_RESULT_MESSAGE, ""));
    }

    static String getFormattedMessage(IStatus status, int ident) {
        StrBuilder builder = new StrBuilder();
        builder.appendPadding(ident, ' ');
        switch (status.getSeverity()) {
            case 8: {
                builder.append("ABORT: ");
                break;
            }
            case 4: {
                builder.append("ERROR: ");
                break;
            }
            case 2: {
                builder.append("WARNING: ");
                break;
            }
            case 1: {
                builder.append("INFO: ");
            }
        }
        builder.append(status.getMessage());
        if (status.getCode() != 0) {
            builder.append(" [code ").append(status.getCode()).append("]");
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                builder.appendNewLine();
                builder.append(JobHistoryImpl.getFormattedMessage(child, ident + 2));
                ++n2;
            }
        }
        return builder.toString();
    }

    public static JobHistoryItemImpl readItem(Preferences node) {
        long ts = node.getLong(KEY_TIMESTAMP, 0L);
        String queuedTrigger = node.get(KEY_QUEUED_TRIGGER, "");
        String cancelledTrigger = node.get(KEY_CANCELLED_TRIGGER, null);
        HashMap<String, String> parameter = null;
        try {
            parameter = JobManagerImpl.readParameter(node);
        }
        catch (BackingStoreException e) {
            LOG.warn("Failed to read parameter for job history {}. {}", new Object[]{node.absolutePath(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return new JobHistoryItemImpl(ts, JobHistoryImpl.deserializeStatus(node), queuedTrigger, cancelledTrigger, parameter);
    }

    private static void serializeStatus(IStatus status, Preferences node) {
        node.put(KEY_RESULT_MESSAGE, status.getMessage());
        node.putInt(KEY_RESULT_SEVERITY, status.getSeverity());
    }

    public JobHistoryImpl(String jobId, IPath contextPath) {
        this.jobId = jobId;
        this.contextPath = contextPath;
    }

    public void createEntry(long resultTimestamp, IStatus result, long lastQueuedTimestamp, String lastQueueTrigger, long lastCanceledTimestamp, String lastCanceledTrigger, Map<String, String> parameter) {
        if (lastQueuedTimestamp > resultTimestamp) {
            lastQueueTrigger = String.format("Specified trigger is incorrect. Job already queued after receiving result. (%s)", lastQueueTrigger);
        }
        if (lastCanceledTimestamp < lastQueuedTimestamp || lastCanceledTimestamp > resultTimestamp) {
            lastCanceledTrigger = null;
        }
        this.entries.add(new JobHistoryItemImpl(resultTimestamp, JobHistoryImpl.convertStatus(result), lastQueueTrigger, lastCanceledTrigger, parameter));
    }

    public IPath getContextPath() {
        return this.contextPath;
    }

    @Override
    public Collection<IJobHistoryEntry> getEntries() {
        if (this.entries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.entries);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void load(IEclipsePreferences historyNode) throws BackingStoreException {
        String[] childrenNames = historyNode.childrenNames();
        this.entries = new TreeSet<IJobHistoryEntry>();
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entryId = stringArray[n2];
            this.entries.add(JobHistoryImpl.readItem(historyNode.node(entryId)));
            ++n2;
        }
        this.shrinkToSizeLimit();
    }

    public void save(IEclipsePreferences historyNode) throws BackingStoreException {
        String[] childrenNames;
        if (this.entries == null) {
            return;
        }
        this.shrinkToSizeLimit();
        for (IJobHistoryEntry entry : this.entries) {
            String entryId = String.valueOf(entry.getTimeStamp());
            if (historyNode.nodeExists(entryId)) continue;
            Preferences node = historyNode.node(entryId);
            node.putLong(KEY_TIMESTAMP, entry.getTimeStamp());
            JobHistoryImpl.serializeStatus(entry.getResult(), node);
            if (entry.getQueuedTrigger() != null) {
                node.put(KEY_QUEUED_TRIGGER, entry.getQueuedTrigger());
            }
            if (entry.getCancelledTrigger() == null) continue;
            node.put(KEY_CANCELLED_TRIGGER, entry.getCancelledTrigger());
        }
        String[] stringArray = childrenNames = historyNode.childrenNames();
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entryId = stringArray[n2];
            Preferences node = historyNode.node(entryId);
            if (!this.entries.contains(JobHistoryImpl.readItem(node))) {
                node.removeNode();
            }
            ++n2;
        }
        historyNode.flush();
    }

    private void shrinkToSizeLimit() {
        while (this.entries.size() > 120) {
            this.entries.remove(this.entries.last());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JobHistoryImpl [jobId=").append(this.jobId).append(", contextPath=").append(this.contextPath).append(", entries=").append(this.entries).append("]");
        return builder.toString();
    }
}

