/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobContext;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.internal.worker.JobLogHelper;
import org.eclipse.gyrex.jobs.internal.worker.JobStateSynchronizer;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerEngine
extends Job {
    private static final long DEFAULT_IDLE_SLEEP_TIME = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_NON_IDLE_SLEEP_TIME = TimeUnit.SECONDS.toMillis(3L);
    private static final long DEFAULT_MAX_SLEEP_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final String NODE_WORKER_ENGINE = "workerEngine";
    private static final String PREF_KEY_SUSPENDED = "suspended";
    private static final Logger LOG = LoggerFactory.getLogger(WorkerEngine.class);
    private final int maxConcurrentJobs;
    private final long idleSleepTime;
    private final long nonIdleSleepTime;
    private long engineSleepTime = DEFAULT_IDLE_SLEEP_TIME;
    private volatile int scheduledJobsCount;
    private final IJobChangeListener jobFinishedListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            WorkerEngine workerEngine = WorkerEngine.this;
            workerEngine.scheduledJobsCount = workerEngine.scheduledJobsCount - 1;
            if (WorkerEngine.this.scheduledJobsCount < 0) {
                WorkerEngine.this.scheduledJobsCount = 0;
            }
        }
    };

    private static Preferences getWorkerEnginePreferences() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_WORKER_ENGINE);
    }

    public static void resume() throws BackingStoreException {
        Preferences preferences = WorkerEngine.getWorkerEnginePreferences();
        preferences.remove(PREF_KEY_SUSPENDED);
        preferences.flush();
    }

    public static void suspend() throws BackingStoreException {
        Preferences preferences = WorkerEngine.getWorkerEnginePreferences();
        preferences.putBoolean(PREF_KEY_SUSPENDED, true);
        preferences.flush();
    }

    public WorkerEngine() {
        super("Gyrex Worker Engine Job");
        this.setSystem(true);
        this.setPriority(30);
        this.idleSleepTime = Long.getLong("gyrex.jobs.workerEngine.idleSleepTime", DEFAULT_IDLE_SLEEP_TIME);
        this.nonIdleSleepTime = Long.getLong("gyrex.jobs.workerEngine.nonIdleSleepTime", DEFAULT_NON_IDLE_SLEEP_TIME);
        this.maxConcurrentJobs = Integer.getInteger("gyrex.jobs.workerEngine.maxConcurrentScheduledJobs", Runtime.getRuntime().availableProcessors() * 2);
    }

    private JobContext createContext(JobInfo info) {
        IRuntimeContextRegistry contextRegistry = (IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class);
        IRuntimeContext context = contextRegistry.get(info.getContextPath());
        if (context == null) {
            throw new IllegalStateException(String.format("Context %s not available!", info.getContextPath().toString()));
        }
        return new JobContext(context, info);
    }

    private Job createJob(IQueue queue, IMessage message, JobInfo info, JobContext jobContext) {
        try {
            JobLogHelper.setupMdc(jobContext);
            Job job = this.createJobInstance(info, jobContext);
            return job;
        }
        catch (LinkageError e) {
            this.handleCreateJobError(queue, message, info, jobContext, e);
            return null;
        }
        catch (Exception e) {
            this.handleCreateJobError(queue, message, info, jobContext, e);
            return null;
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }

    private Job createJobInstance(JobInfo info, IJobContext jobContext) throws Exception {
        JobProvider provider = JobsActivator.getInstance().getJobProviderRegistry().getProvider(info.getJobTypeId());
        if (provider == null) {
            throw new IllegalStateException(String.format("Job type %s not available!", info.getJobTypeId()));
        }
        Job job = provider.createJob(info.getJobTypeId(), jobContext);
        if (job == null) {
            throw new IllegalStateException(String.format("Provider %s did not create job of type %s!", provider.toString(), info.getJobTypeId()));
        }
        return job;
    }

    private void discardJobMessage(IQueue queue, IMessage message) {
        try {
            if (!queue.deleteMessage(message)) {
                LOG.warn("Unable to remove job message {}. Job might be processed again.", (Object)message);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            LOG.error("Error removing job message {}: {}", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    protected IQueue getDefaultQueue() {
        IQueueService queueService = JobsActivator.getInstance().getQueueService();
        IQueue queue = queueService.getQueue("gyrex.jobs.queue.default", null);
        if (queue == null) {
            queueService.createQueue("gyrex.jobs.queue.default", null);
        }
        return queueService.getQueue("gyrex.jobs.queue.default", null);
    }

    protected long getReceiveTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    private void handleCreateJobError(IQueue queue, IMessage message, JobInfo info, JobContext jobContext, Throwable e) {
        LOG.error("Error creating job {}: {}. Job won't be executed.", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        this.discardJobMessage(queue, message);
        try {
            JobManagerImpl jobManager = (JobManagerImpl)jobContext.getContext().get(IJobManager.class);
            jobManager.setResult(info.getJobId(), jobContext.getParameter(), (IStatus)new Status(4, "org.eclipse.gyrex.jobs", String.format("Error creating job: %s", e.getMessage()), e), System.currentTimeMillis());
        }
        catch (Exception jobManagerException) {
            LOG.error("Error updating job result for job {}: {}", new Object[]{info.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)jobManagerException)});
        }
    }

    private JobInfo parseJobInfo(IQueue queue, IMessage message) {
        try {
            return JobInfo.parse(message);
        }
        catch (IOException e) {
            LOG.error("Invalid job info in message {}: {}", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            this.discardJobMessage(queue, message);
            return null;
        }
    }

    private boolean processNextJobFromQueue() {
        IQueue queue = this.getDefaultQueue();
        if (queue == null) {
            throw new IllegalStateException("No queue available for reading scheduled jobs to execute. Please check engine configuration.");
        }
        if (this.scheduledJobsCount > this.maxConcurrentJobs) {
            if (JobsDebug.workerEngine) {
                LOG.debug("There are currently {} jobs scheduled. Won't schedule more at this time.", (Object)this.scheduledJobsCount);
            }
            return false;
        }
        HashMap<String, Long> requestProperties = new HashMap<String, Long>(1);
        requestProperties.put("queue.message.receive.timeout", this.getReceiveTimeout());
        List messages = queue.receiveMessages(1, requestProperties);
        if (messages.isEmpty()) {
            return false;
        }
        IMessage message = (IMessage)messages.get(0);
        JobInfo info = this.parseJobInfo(queue, message);
        if (info == null) {
            return true;
        }
        JobContext jobContext = this.createContext(info);
        Job job = this.createJob(queue, message, info, jobContext);
        if (job == null) {
            return true;
        }
        JobStateSynchronizer stateSynchronizer = new JobStateSynchronizer(job, jobContext);
        job.addJobChangeListener((IJobChangeListener)stateSynchronizer);
        job.addJobChangeListener(this.jobFinishedListener);
        stateSynchronizer.setJobActive();
        try {
            if (!queue.deleteMessage(message)) {
                stateSynchronizer.setJobInactive();
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            stateSynchronizer.setJobInactive();
            return true;
        }
        job.schedule();
        ++this.scheduledJobsCount;
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (WorkerEngine.getWorkerEnginePreferences().getBoolean(PREF_KEY_SUSPENDED, false)) {
                if (JobsDebug.workerEngine) {
                    LOG.debug("Worker engine is suspended.");
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            boolean moreJobsAvailable = this.processNextJobFromQueue();
            this.engineSleepTime = moreJobsAvailable ? this.nonIdleSleepTime : this.idleSleepTime;
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.engineSleepTime = Math.min(this.engineSleepTime * 2L, DEFAULT_MAX_SLEEP_TIME);
            LOG.error("Unable to process queued jobs. Please verify the system is setup properly. {}", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            if (!monitor.isCanceled()) {
                if (JobsDebug.workerEngine) {
                    LOG.debug("Rescheduling worker engine to run again in {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(this.engineSleepTime));
                }
                this.schedule(this.engineSleepTime);
            }
        }
    }
}

