/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal.model;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.logback.config.internal.model.Appender;
import org.eclipse.gyrex.logback.config.internal.model.Logger;

public class LogbackConfig {
    private Map<String, Appender> appenders;
    private Map<String, Logger> loggers;
    private boolean shortenStackTraces;
    private Level defaultLevel;
    private List<String> defaultAppenders;

    static void writeProperty(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeEmptyElement("property");
        writer.writeAttribute("name", name);
        writer.writeAttribute("value", value);
    }

    public void addAppender(Appender appender) {
        if (StringUtils.isBlank((String)appender.getName())) {
            throw new IllegalArgumentException("appender name must not be blank");
        }
        this.getAppenders().put(appender.getName(), appender);
    }

    private String addExceptionPattern(String pattern) {
        if (this.isShortenStackTraces()) {
            return String.valueOf(pattern) + "%rootException{6}";
        }
        return String.valueOf(pattern) + "%rootException";
    }

    public void addLogger(Logger logger) {
        if (StringUtils.isBlank((String)logger.getName())) {
            throw new IllegalArgumentException("logger name must not be blank");
        }
        this.getLoggers().put(logger.getName(), logger);
    }

    public Map<String, Appender> getAppenders() {
        if (this.appenders == null) {
            this.appenders = new LinkedHashMap<String, Appender>();
        }
        return this.appenders;
    }

    public List<String> getDefaultAppenders() {
        if (this.defaultAppenders == null) {
            this.defaultAppenders = new ArrayList<String>();
        }
        return this.defaultAppenders;
    }

    public Level getDefaultLevel() {
        if (this.defaultLevel == null) {
            return Level.INFO;
        }
        return this.defaultLevel;
    }

    public Map<String, Logger> getLoggers() {
        if (this.loggers == null) {
            this.loggers = new LinkedHashMap<String, Logger>();
        }
        return this.loggers;
    }

    private String getLongPattern() {
        return this.addExceptionPattern("%date{ISO8601} [%thread.%property{HOSTNAME}] %-5level %logger{36} %mdc{gyrex.contextPath, '[CTX:', '] '}%mdc{gyrex.applicationId, '[APP:', '] '}%mdc{gyrex.jobId, '[JOB:', '] '}- %msg%n");
    }

    private String getShortPattern() {
        return this.addExceptionPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
    }

    public boolean isShortenStackTraces() {
        return this.shortenStackTraces;
    }

    public void setDefaultAppenders(List<String> defaultAppenders) {
        this.defaultAppenders = defaultAppenders;
    }

    public void setDefaultLevel(Level defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public void setShortenStackTraces(boolean shortenStackTraces) {
        this.shortenStackTraces = shortenStackTraces;
    }

    public void toXml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("configuration");
        writer.writeAttribute("scan", "true");
        writer.writeAttribute("scanPeriod", "2 minutes");
        this.writeCommonProperties(writer);
        this.writeJulLevelChangePropagator(writer);
        for (Appender appender : this.getAppenders().values()) {
            appender.toXml(writer);
        }
        for (Logger logger : this.getLoggers().values()) {
            logger.toXml(writer);
        }
        this.writeRootLogger(writer);
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void writeCommonProperties(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment("common properties");
        LogbackConfig.writeProperty(writer, "BASE_PATH", "${gyrex.instance.area.logs:-logs}");
        LogbackConfig.writeProperty(writer, "PATTERN_SHORT", this.getShortPattern());
        LogbackConfig.writeProperty(writer, "PATTERN_LONG", this.getLongPattern());
    }

    private void writeJulLevelChangePropagator(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment("propagate log level changes to JUL");
        writer.writeStartElement("contextListener");
        writer.writeAttribute("class", LevelChangePropagator.class.getName());
        writer.writeStartElement("resetJUL");
        writer.writeCData("true");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("root");
        writer.writeAttribute("level", this.getDefaultLevel().toString());
        for (String appenderRef : this.getDefaultAppenders()) {
            writer.writeEmptyElement("appender-ref");
            writer.writeAttribute("ref", appenderRef);
        }
        writer.writeEndElement();
    }
}

