/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.CharSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public abstract class BaseMetric {
    static final CharSet ALLOWED_ID_CHARS = CharSet.getInstance((String[])new String[]{"a-z", "A-Z", "0-9", ".", "-", "_"});
    static final String[] NO_METRICS = new String[0];
    static final DateFormat ISO_8601_UTC = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private final String id;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile long statsSince;

    public static boolean isValidId(String id) {
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        char[] cArray = id.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!ALLOWED_ID_CHARS.contains(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    BaseMetric(String id) {
        if (!BaseMetric.isValidId(id)) {
            throw new IllegalArgumentException("id is invalid (see BaseMetric#isValidId): " + id);
        }
        this.id = id;
        this.statsSince = System.currentTimeMillis();
    }

    void doResetStats() {
    }

    Object[] dumpMetrics() {
        return NO_METRICS;
    }

    public final List<MetricAttribute> getAttributes() {
        ArrayList<MetricAttribute> attributes = new ArrayList<MetricAttribute>();
        this.populateAttributes(attributes);
        return Collections.unmodifiableList(attributes);
    }

    public final Map<String, ?> getAttributeValues() {
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            this.populateAttributeValues(attributeValues);
        }
        finally {
            lock.unlock();
        }
        return Collections.unmodifiableMap(attributeValues);
    }

    public final String getId() {
        return this.id;
    }

    final Lock getReadLock() {
        return this.readWriteLock.readLock();
    }

    public final String getStatsSince() {
        return ISO_8601_UTC.format(new Date(this.statsSince));
    }

    protected final long getStatsSinceTS() {
        return this.statsSince;
    }

    final Lock getWriteLock() {
        return this.readWriteLock.writeLock();
    }

    void populateAttributes(List<MetricAttribute> attributes) {
        attributes.add(new MetricAttribute("statsSince", "the last reset time", String.class));
    }

    void populateAttributeValues(Map<String, Object> values) {
        values.put("statsSince", this.getStatsSince());
    }

    public final void resetStats() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.statsSince = System.currentTimeMillis();
            this.doResetStats();
        }
        finally {
            writeLock.unlock();
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.getClass().getSimpleName()).append('(').append(this.getId()).append(')');
        toString.append(" {");
        Object[] metrics = this.dumpMetrics();
        int i = 0;
        while (i < metrics.length) {
            Object metric;
            if (i > 0) {
                toString.append(',');
            }
            if ((metric = metrics[i]) != null) {
                toString.append(metric);
            }
            ++i;
        }
        toString.append('}');
        return toString.toString();
    }
}

