/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoManager
implements IRepositoryDefinitionManager {
    private static final String PREF_NODE_REPOSITORIES = "repositories";
    private static final String PREF_KEY_NODE_FILTER = "nodeFilter";
    private static final String PREF_KEY_LOCATION = "location";
    private static final Logger LOG = LoggerFactory.getLogger(RepoManager.class);

    private Preferences getRepoNode(String repoId) {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2").node(PREF_NODE_REPOSITORIES).node(repoId);
    }

    @Override
    public Collection<RepositoryDefinition> getRepositories() {
        try {
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_REPOSITORIES)) {
                return Collections.emptyList();
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_REPOSITORIES);
            String[] childrenNames = channelsNode.childrenNames();
            ArrayList<RepositoryDefinition> repos = new ArrayList<RepositoryDefinition>();
            String[] stringArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String repoId = stringArray[n2];
                RepositoryDefinition repo = this.readRepo(repoId);
                if (repo != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos;
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error reading repositories from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    private RepositoryDefinition readRepo(String repoId) {
        try {
            RepositoryDefinition descriptor = new RepositoryDefinition();
            descriptor.setId(repoId);
            Preferences node = this.getRepoNode(repoId);
            descriptor.setLocation(new URI(node.get(PREF_KEY_LOCATION, null)));
            descriptor.setNodeFilter(node.get(PREF_KEY_NODE_FILTER, null));
            return descriptor;
        }
        catch (Exception e) {
            LOG.warn("Unable to read repository definition {}. {}", (Object)repoId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    @Override
    public void removeRepository(String id) {
        try {
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException("invalid id");
            }
            IEclipsePreferences rootNode = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.p2");
            if (!rootNode.nodeExists(PREF_NODE_REPOSITORIES)) {
                return;
            }
            Preferences channelsNode = rootNode.node(PREF_NODE_REPOSITORIES);
            if (!channelsNode.nodeExists(id)) {
                return;
            }
            channelsNode.node(id).removeNode();
            channelsNode.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error removing repository from backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    @Override
    public void saveRepository(RepositoryDefinition repository) {
        try {
            String id = repository.getId();
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException("invalid repository id");
            }
            URI location = repository.getLocation();
            if (location == null) {
                throw new IllegalArgumentException("repository must have a location");
            }
            Preferences node = this.getRepoNode(id);
            node.put(PREF_KEY_LOCATION, location.toString());
            String nodeFilter = repository.getNodeFilter();
            if (StringUtils.isNotBlank((String)nodeFilter)) {
                node.put(PREF_KEY_NODE_FILTER, nodeFilter);
            } else {
                node.remove(PREF_KEY_NODE_FILTER);
            }
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Error saving repository to backend store. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }
}

