/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.mongodb.internal.commands;

import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.persistence.mongodb.internal.MongoDbRegistry;
import org.kohsuke.args4j.Argument;

public class ConfigurePool
extends Command {
    @Argument(index=0, usage="specifies the pool identifier", metaVar="POOLID", required=true)
    private String poolId;
    @Argument(index=1, usage="specifies the Mongo connect URI", metaVar="URI", required=true)
    private String uri;

    public ConfigurePool() {
        super("<poolId> <uri> - creates/configures a pool");
    }

    protected void doExecute() throws Exception {
        Mongo mongo = new MongoURI(this.uri).connect();
        mongo.close();
        MongoDbRegistry.configurePool(this.poolId, this.uri);
        this.printf("Configured pool '%s' with '%s'.", new Object[]{this.poolId, this.uri});
    }
}

