/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.persistence.storage.RepositoryMetadata;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.osgi.service.prefs.BackingStoreException;

public final class RepositoryPreferencesBasedMetadata
extends RepositoryMetadata {
    private static final String METADATA = "metadata";
    private final IRepositoryPreferences preferences;
    private final IPath nodePath;
    private final String metadataId;
    private final String repositoryId;

    public RepositoryPreferencesBasedMetadata(IRepositoryPreferences preferences, String metadataId, String repositoryId) {
        if (!IdHelper.isValidId((String)metadataId)) {
            throw new IllegalArgumentException(String.format("invalid metadata id: %s (repository %s)", metadataId, repositoryId));
        }
        if (!IdHelper.isValidId((String)repositoryId)) {
            throw new IllegalArgumentException(String.format("invalid repository id: %s (metadata %s)", repositoryId, metadataId));
        }
        this.preferences = preferences;
        this.metadataId = metadataId;
        this.repositoryId = repositoryId;
        this.nodePath = new Path(METADATA).append(metadataId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        try {
            String[] childrenNames;
            String[] stringArray = childrenNames = this.preferences.getChildrenNames(METADATA);
            int n = childrenNames.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String childName = stringArray[n2];
                if (this.metadataId.equals(childName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        this.preferences.flush();
    }

    @Override
    public byte[] get(String key) throws IllegalArgumentException {
        return this.preferences.getByteArray(this.getPathToKey(key), null);
    }

    @Override
    public String getId() {
        return this.metadataId;
    }

    @Override
    public Collection<String> getKeys() throws BackingStoreException {
        return Collections.unmodifiableCollection(Arrays.asList(this.preferences.getKeys(this.nodePath.toString())));
    }

    private String getPathToKey(String key) {
        if (!IdHelper.isValidId((String)key)) {
            throw new IllegalArgumentException(String.format("invalid key: %s (metadata %s for repository %s)", key, this.metadataId, this.repositoryId));
        }
        return this.nodePath.append(key).toString();
    }

    @Override
    public void put(String key, byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("data must not be null (key %s, metadata %s for repository %s)", key, this.metadataId, this.repositoryId));
        }
        this.preferences.putByteArray(this.getPathToKey(key), data, false);
    }

    @Override
    public void remove() throws BackingStoreException {
        this.preferences.remove(this.nodePath.toString());
    }

    @Override
    public void remove(String key) throws IllegalArgumentException {
        this.preferences.remove(this.getPathToKey(key));
    }

    @Override
    public void sync() throws BackingStoreException {
        this.preferences.sync();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RepositoryPreferencesBasedMetadata [metadataId=").append(this.metadataId).append(", repositoryId=").append(this.repositoryId).append("]");
        return builder.toString();
    }
}

