/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.Diff;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_show")
class Show
extends TextBuiltin {
    private final TimeZone myTZ = TimeZone.getDefault();
    private final DateFormat fmt;
    private final DiffFormatter diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(System.out));
    @Argument(index=0, metaVar="metaVar_object")
    private String objectName;
    @Option(name="--", metaVar="metaVar_path", multiValued=true, handler=PathTreeFilterHandler.class)
    protected TreeFilter pathFilter = TreeFilter.ALL;
    @Option(name="-p", usage="usage_showPatch")
    boolean showPatch;
    @Option(name="-M", usage="usage_detectRenames")
    private Boolean detectRenames;
    @Option(name="-l", usage="usage_renameLimit")
    private Integer renameLimit;
    @Option(name="--name-status", usage="usage_nameStatus")
    private boolean showNameAndStatusOnly;

    @Option(name="--no-renames", usage="usage_noRenames")
    void noRenames(boolean on) {
        this.detectRenames = Boolean.FALSE;
    }

    @Option(name="--ignore-space-at-eol")
    void ignoreSpaceAtEol(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_TRAILING);
    }

    @Option(name="--ignore-leading-space")
    void ignoreLeadingSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_LEADING);
    }

    @Option(name="-b", aliases={"--ignore-space-change"})
    void ignoreSpaceChange(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_CHANGE);
    }

    @Option(name="-w", aliases={"--ignore-all-space"})
    void ignoreAllSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
    }

    @Option(name="-U", aliases={"--unified"}, metaVar="metaVar_linesOfContext")
    void unified(int lines) {
        this.diffFmt.setContext(lines);
    }

    @Option(name="--abbrev", metaVar="metaVar_n")
    void abbrev(int lines) {
        this.diffFmt.setAbbreviationLength(lines);
    }

    @Option(name="--full-index")
    void abbrev(boolean on) {
        this.diffFmt.setAbbreviationLength(40);
    }

    @Option(name="--src-prefix", usage="usage_srcPrefix")
    void sourcePrefix(String path) {
        this.diffFmt.setOldPrefix(path);
    }

    @Option(name="--dst-prefix", usage="usage_dstPrefix")
    void dstPrefix(String path) {
        this.diffFmt.setNewPrefix(path);
    }

    @Option(name="--no-prefix", usage="usage_noPrefix")
    void noPrefix(boolean on) {
        this.diffFmt.setOldPrefix("");
        this.diffFmt.setNewPrefix("");
    }

    Show() {
        this.fmt = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy ZZZZZ", Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void run() throws Exception {
        this.diffFmt.setRepository(this.db);
        try {
            this.diffFmt.setPathFilter(this.pathFilter);
            if (this.detectRenames != null) {
                this.diffFmt.setDetectRenames(this.detectRenames.booleanValue());
            }
            if (this.renameLimit != null && this.diffFmt.isDetectRenames()) {
                RenameDetector rd = this.diffFmt.getRenameDetector();
                rd.setRenameLimit(this.renameLimit.intValue());
            }
            ObjectId objectId = this.objectName == null ? this.db.resolve("HEAD") : this.db.resolve(this.objectName);
            RevWalk rw = new RevWalk(this.db);
            try {
                RevObject obj = rw.parseAny((AnyObjectId)objectId);
                while (obj instanceof RevTag) {
                    this.show((RevTag)obj);
                    obj = ((RevTag)obj).getObject();
                    rw.parseBody(obj);
                }
                switch (obj.getType()) {
                    case 1: {
                        this.show(rw, (RevCommit)obj);
                        return;
                    }
                    case 2: {
                        this.outw.print((Object)"tree ");
                        this.outw.print((Object)this.objectName);
                        this.outw.println();
                        this.outw.println();
                        this.show((RevTree)obj);
                        return;
                    }
                    case 3: {
                        this.db.open((AnyObjectId)obj, obj.getType()).copyTo((OutputStream)System.out);
                        this.outw.flush();
                        return;
                    }
                    default: {
                        throw Show.die(MessageFormat.format(CLIText.get().cannotReadBecause, obj.name(), obj.getType()));
                    }
                }
            }
            finally {
                rw.release();
            }
        }
        finally {
            this.diffFmt.release();
        }
    }

    private void show(RevTag tag) throws IOException {
        String[] lines;
        this.outw.print((Object)CLIText.get().tagLabel);
        this.outw.print((Object)" ");
        this.outw.print((Object)tag.getTagName());
        this.outw.println();
        PersonIdent tagger = tag.getTaggerIdent();
        if (tagger != null) {
            this.outw.println(MessageFormat.format(CLIText.get().taggerInfo, tagger.getName(), tagger.getEmailAddress()));
            TimeZone taggerTZ = tagger.getTimeZone();
            this.fmt.setTimeZone(taggerTZ != null ? taggerTZ : this.myTZ);
            this.outw.println(MessageFormat.format(CLIText.get().dateInfo, this.fmt.format(tagger.getWhen())));
        }
        this.outw.println();
        for (String s : lines = tag.getFullMessage().split("\n")) {
            this.outw.print((Object)"    ");
            this.outw.print((Object)s);
            this.outw.println();
        }
        this.outw.println();
    }

    private void show(RevTree obj) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk walk = new TreeWalk(this.db);
        walk.reset();
        walk.addTree((AnyObjectId)obj);
        while (walk.next()) {
            this.outw.print((Object)walk.getPathString());
            FileMode mode = walk.getFileMode(0);
            if (mode == FileMode.TREE) {
                this.outw.print((Object)"/");
            }
            this.outw.println();
        }
    }

    private void show(RevWalk rw, RevCommit c) throws Exception {
        String[] lines;
        char[] outbuffer = new char[40];
        this.outw.print((Object)CLIText.get().commitLabel);
        this.outw.print((Object)" ");
        c.getId().copyTo(outbuffer, (Writer)this.outw);
        this.outw.println();
        PersonIdent author = c.getAuthorIdent();
        this.outw.println(MessageFormat.format(CLIText.get().authorInfo, author.getName(), author.getEmailAddress()));
        TimeZone authorTZ = author.getTimeZone();
        this.fmt.setTimeZone(authorTZ != null ? authorTZ : this.myTZ);
        this.outw.println(MessageFormat.format(CLIText.get().dateInfo, this.fmt.format(author.getWhen())));
        this.outw.println();
        for (String s : lines = c.getFullMessage().split("\n")) {
            this.outw.print((Object)"    ");
            this.outw.print((Object)s);
            this.outw.println();
        }
        this.outw.println();
        if (c.getParentCount() == 1) {
            rw.parseHeaders((RevObject)c.getParent(0));
            this.showDiff(c);
        }
        this.outw.flush();
    }

    private void showDiff(RevCommit c) throws IOException {
        RevTree a = c.getParent(0).getTree();
        RevTree b = c.getTree();
        if (this.showNameAndStatusOnly) {
            Diff.nameStatus(this.outw, this.diffFmt.scan(a, b));
        } else {
            this.outw.flush();
            this.diffFmt.format(a, b);
            this.diffFmt.flush();
        }
        this.outw.println();
    }
}

