/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;

public class ChangeIdUtil {
    static final String CHANGE_ID = "Change-Id:";
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");

    static String clean(String msg) {
        return msg.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId treeId, ObjectId firstParentId, PersonIdent author, PersonIdent committer, String message) throws IOException {
        String cleanMessage = ChangeIdUtil.clean(message);
        if (cleanMessage.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("tree ");
        b.append(ObjectId.toString(treeId));
        b.append("\n");
        if (firstParentId != null) {
            b.append("parent ");
            b.append(ObjectId.toString(firstParentId));
            b.append("\n");
        }
        b.append("author ");
        b.append(author.toExternalString());
        b.append("\n");
        b.append("committer ");
        b.append(committer.toExternalString());
        b.append("\n\n");
        b.append(cleanMessage);
        return new ObjectInserter.Formatter().idFor(1, b.toString().getBytes("UTF-8"));
    }

    public static String insertId(String message, ObjectId changeId) {
        return ChangeIdUtil.insertId(message, changeId, false);
    }

    public static String insertId(String message, ObjectId changeId, boolean replaceExisting) {
        int i;
        int footerFirstLine;
        int indexOfChangeId = ChangeIdUtil.indexOfChangeId(message, "\n");
        if (indexOfChangeId > 0) {
            if (!replaceExisting) {
                return message;
            }
            StringBuilder ret = new StringBuilder(message.substring(0, indexOfChangeId));
            ret.append(CHANGE_ID);
            ret.append(" I");
            ret.append(ObjectId.toString(changeId));
            int indexOfNextLineBreak = message.indexOf("\n", indexOfChangeId);
            if (indexOfNextLineBreak > 0) {
                ret.append(message.substring(indexOfNextLineBreak));
            }
            return ret.toString();
        }
        String[] lines = message.split("\n");
        int insertAfter = footerFirstLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        for (int i2 = footerFirstLine; i2 < lines.length && issuePattern.matcher(lines[i2]).matches(); ++i2) {
            insertAfter = i2 + 1;
        }
        StringBuilder ret = new StringBuilder();
        for (i = 0; i < insertAfter; ++i) {
            ret.append(lines[i]);
            ret.append("\n");
        }
        if (insertAfter == lines.length && insertAfter == footerFirstLine) {
            ret.append("\n");
        }
        ret.append(CHANGE_ID);
        ret.append(" I");
        ret.append(ObjectId.toString(changeId));
        ret.append("\n");
        while (i < lines.length) {
            ret.append(lines[i]);
            ret.append("\n");
            ++i;
        }
        return ret.toString();
    }

    public static int indexOfChangeId(String message, String delimiter) {
        String[] lines = message.split(delimiter);
        int footerFirstLine = ChangeIdUtil.indexOfFirstFooterLine(lines);
        if (footerFirstLine == lines.length) {
            return -1;
        }
        int indexOfFooter = 0;
        for (int i = 0; i < footerFirstLine; ++i) {
            indexOfFooter += lines[i].length() + delimiter.length();
        }
        return message.indexOf(CHANGE_ID, indexOfFooter);
    }

    public static int indexOfFirstFooterLine(String[] lines) {
        int footerFirstLine = lines.length;
        for (int i = lines.length - 1; i > 1; --i) {
            if (footerPattern.matcher(lines[i]).matches()) {
                footerFirstLine = i;
                continue;
            }
            if (footerFirstLine != lines.length && lines[i].length() == 0) break;
            if (footerFirstLine != lines.length && includeInFooterPattern.matcher(lines[i]).matches()) {
                footerFirstLine = i + 1;
                continue;
            }
            footerFirstLine = lines.length;
            break;
        }
        return footerFirstLine;
    }
}

