/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.util.ConcurrentModificationException;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemTreeContentProvider<I, C>
implements ItemTreeContentProvider {
    protected final ItemTreeContentProvider.Manager manager;
    protected final I item;
    protected volatile CollectionValueModel<C> childrenModel;
    protected volatile CollectionChangeListener childrenListener;

    protected AbstractItemTreeContentProvider(I item, ItemTreeContentProvider.Manager manager) {
        this.item = item;
        this.manager = manager;
    }

    @Override
    public Object[] getElements() {
        return this.getChildren();
    }

    @Override
    public Object[] getChildren() {
        while (true) {
            try {
                return ArrayTools.array(this.getChildrenModel());
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    protected synchronized CollectionValueModel<C> getChildrenModel() {
        if (this.childrenModel == null) {
            this.childrenModel = this.buildChildrenModel();
            this.childrenListener = this.buildChildrenListener();
            this.engageChildrenModel();
        }
        return this.childrenModel;
    }

    protected abstract CollectionValueModel<C> buildChildrenModel();

    @Override
    public boolean hasChildren() {
        return this.getChildrenModel().iterator().hasNext();
    }

    protected void engageChildrenModel() {
        this.childrenModel.addCollectionChangeListener("values", this.childrenListener);
    }

    protected void disengageChildrenModel() {
        this.childrenModel.removeCollectionChangeListener("values", this.childrenListener);
    }

    protected CollectionChangeListener buildChildrenListener() {
        return new ChildrenListener();
    }

    protected void childrenAdded(Iterable<C> children) {
        this.manager.updateChildren(this.item);
    }

    protected void childrenRemoved(Iterable<C> children) {
        this.manager.updateChildren(this.item);
        for (C child : children) {
            this.manager.dispose(child);
        }
    }

    protected void childrenChanged() {
        this.manager.updateChildren(this.item);
    }

    @Override
    public synchronized void dispose() {
        if (this.childrenModel != null) {
            this.dispose_();
        }
    }

    protected void dispose_() {
        for (Object child : this.childrenModel) {
            this.manager.dispose(child);
        }
        this.disengageChildrenModel();
        this.childrenModel = null;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.item);
    }

    protected class ChildrenListener
    extends CollectionChangeAdapter {
        protected ChildrenListener() {
        }

        public void itemsAdded(CollectionAddEvent event) {
            AbstractItemTreeContentProvider.this.childrenAdded(event.getItems());
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            AbstractItemTreeContentProvider.this.childrenRemoved(event.getItems());
        }

        public void collectionChanged(CollectionChangeEvent event) {
            AbstractItemTreeContentProvider.this.childrenChanged();
        }

        public void collectionCleared(CollectionClearEvent event) {
            AbstractItemTreeContentProvider.this.childrenChanged();
        }
    }
}

