/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility;

import java.io.Serializable;

public interface BooleanReference {
    public boolean getValue();

    public boolean is(boolean var1);

    public boolean isNot(boolean var1);

    public boolean isTrue();

    public boolean isFalse();

    public static final class False
    implements BooleanReference,
    Serializable {
        public static final BooleanReference INSTANCE = new False();
        private static final long serialVersionUID = 1L;

        public static BooleanReference instance() {
            return INSTANCE;
        }

        private False() {
        }

        public boolean getValue() {
            return false;
        }

        public boolean is(boolean value) {
            return !value;
        }

        public boolean isNot(boolean value) {
            return value;
        }

        public boolean isTrue() {
            return false;
        }

        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "[false]";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class True
    implements BooleanReference,
    Serializable {
        public static final BooleanReference INSTANCE = new True();
        private static final long serialVersionUID = 1L;

        public static BooleanReference instance() {
            return INSTANCE;
        }

        private True() {
        }

        public boolean getValue() {
            return true;
        }

        public boolean is(boolean value) {
            return value;
        }

        public boolean isNot(boolean value) {
            return !value;
        }

        public boolean isTrue() {
            return true;
        }

        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "[true]";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Value {
        public static BooleanReference of(boolean value) {
            return value ? True.instance() : False.instance();
        }
    }
}

